/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

public class Explosion {
    private static int[] typeSequence = new int[]{5, 7, 4, 6, 7, 4, 5, 6, 7, 4, 5, 6, 6, 7, 4, 4, 5, 5, 6, 6, 7, 7, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7};
    private static int[] scaleSequence;
    private static int[] scaleIndex;
    private int index;
    private int curFrame;
    private int baseFrame;
    private int x;
    private int y;

    static {
        int[] nArray = new int[37];
        nArray[0] = 11;
        nArray[1] = 11;
        nArray[2] = 12;
        nArray[3] = 12;
        nArray[4] = 12;
        nArray[5] = 13;
        nArray[6] = 13;
        nArray[7] = 13;
        nArray[8] = 13;
        nArray[9] = 14;
        nArray[10] = 14;
        nArray[11] = 14;
        nArray[12] = 14;
        nArray[13] = 14;
        nArray[14] = 15;
        nArray[15] = 15;
        nArray[16] = 15;
        nArray[17] = 15;
        nArray[18] = 15;
        nArray[19] = 15;
        nArray[20] = 15;
        nArray[21] = 15;
        scaleSequence = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 22;
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[6] = -1;
        nArray2[7] = -1;
        nArray2[8] = -1;
        nArray2[9] = -1;
        nArray2[10] = -1;
        nArray2[12] = 2;
        nArray2[13] = 5;
        nArray2[14] = 9;
        nArray2[15] = 14;
        scaleIndex = nArray2;
    }

    public Explosion(int frameNo, int sx, int sy, int t, int s) {
        this.baseFrame = frameNo;
        this.curFrame = frameNo;
        this.x = sx;
        this.y = sy;
        int index = Explosion.getAnimationIndex(t, s);
        this.baseFrame = this.curFrame - index;
    }

    public boolean match(int frameNo, int sx, int sy, int t, int s) {
        this.curFrame = frameNo;
        int index = this.curFrame - this.baseFrame;
        if (sx != this.x || sy != this.y) {
            return false;
        }
        if (index < 0 || index > 36) {
            System.out.printf("Explosion index %d is out of range [0..36]\n", index);
            return false;
        }
        if (t != typeSequence[index]) {
            System.out.printf("Explosion type %d does not match typeSequence[%d] (%d)\n", t, index, typeSequence[index]);
            return false;
        }
        if (s != scaleSequence[index]) {
            System.out.printf("Explosion scale %d does not match scaleSequence[%d] (%d)\n", s, index, scaleSequence[index]);
            return false;
        }
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public int getFramesRemaining(int frameNo) {
        return 37 - (frameNo - this.baseFrame);
    }

    private static int getAnimationIndex(int t, int s) {
        if (s >= 0 && s < 16) {
            int i = scaleIndex[s];
            while (i < 37 && scaleSequence[i] == s) {
                if (t == typeSequence[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

