/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.comm.Communicator;
import de.heise.asteroid.comm.FramePacket;
import de.heise.asteroid.comm.KeyPacket;
import de.heise.asteroid.engine.FrameInterpreter;
import de.heise.asteroid.engine.FrameProcessor;
import de.heise.asteroid.engine.GameStarter;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.engine.HallOfFameEditor;
import de.heise.asteroid.engine.IdleProcessor;
import de.heise.asteroid.engine.TextInterpreter;
import de.heise.asteroid.player.Player;
import de.heise.asteroid.util.WorkerRunnable;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine
implements WorkerRunnable {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_WAIT_START = 1;
    public static final int STATE_WAIT_PLAY = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_GAME_OVER = 4;
    public static final int STATE_HIGHSCORE = 5;
    public static final int STATE_ERROR = 99;
    private Communicator comm;
    int frameCnt;
    private FrameInterpreter frameInterpreter;
    private TextInterpreter textInterpreter;
    private List<FramePacket> fpQueue;
    private List<KeyPacket> kpQueue;
    private int state;
    private FrameProcessor[] stateHandlers;
    private GameStatus status;
    private boolean syncComm;
    private int gamesCompleted;
    private int gamesToPlay;

    public Engine(Communicator c, GameStatus s, int numGames) {
        this.comm = c;
        this.status = s;
        this.gamesToPlay = numGames;
        this.frameInterpreter = new FrameInterpreter(this.status);
        this.textInterpreter = new TextInterpreter(this.status);
        this.fpQueue = null;
        this.kpQueue = null;
        this.syncComm = true;
        this.state = 0;
        this.stateHandlers = new FrameProcessor[6];
        IdleProcessor idle = new IdleProcessor(this);
        this.stateHandlers[0] = idle;
        this.stateHandlers[1] = new GameStarter(this);
        this.stateHandlers[2] = idle;
        this.stateHandlers[3] = null;
        this.stateHandlers[4] = idle;
        this.stateHandlers[5] = null;
    }

    public void setQueues(List<FramePacket> fpq, List<KeyPacket> kpq) {
        this.fpQueue = fpq;
        this.kpQueue = kpq;
    }

    public void registerPlayer(Player p) {
        this.stateHandlers[3] = p;
        this.stateHandlers[5] = new HallOfFameEditor(this, p.getInitials());
    }

    @Override
    public void workerInitialize() {
        this.gamesCompleted = 0;
        this.syncComm = this.fpQueue == null;
        System.out.println("Engine started in " + (this.syncComm ? "synchronous" : "asynchronous") + " mode.");
        this.frameCnt = 0;
        this.state = 0;
        System.out.println("Initial state: " + Engine.getStateString(this.state));
        if (this.syncComm) {
            this.comm.workerInitialize();
        }
    }

    @Override
    public boolean workerMainLoop() {
        FramePacket fp;
        FramePacket framePacket = fp = this.syncComm ? this.comm.receiveFramePacket() : this.getFramePacket();
        if (fp != null) {
            if (this.syncComm) {
                this.comm.transmitKeyPacket();
            }
            int frameNo = fp.getRealFrameNo();
            this.textInterpreter.interpretFrame(fp);
            int newState = this.textInterpreter.getState();
            if (newState != this.state) {
                if (newState == 99) {
                    return false;
                }
                if (this.state == 5 || this.state == 4 && newState != 5) {
                    ++this.gamesCompleted;
                }
                System.out.printf("State transition: %s --> %s\n", Engine.getStateString(this.state), Engine.getStateString(newState));
                this.state = newState;
                this.frameInterpreter.transitState(this.state);
                if (this.stateHandlers[this.state] != null) {
                    this.comm.flushKeyQueue();
                    this.stateHandlers[this.state].initialize();
                } else {
                    System.out.println("ERROR: No FrameProcessor for state " + Engine.getStateString(this.state));
                    this.state = 0;
                }
            }
            this.frameInterpreter.interpretFrame(fp);
            this.comm.recycle(fp);
            if (this.stateHandlers[this.state] != null) {
                this.stateHandlers[this.state].process(this.status, frameNo);
            }
            ++this.frameCnt;
            return this.gamesCompleted < this.gamesToPlay;
        }
        return false;
    }

    @Override
    public void workerFinalize() {
        System.out.printf("Engine stopped after %d frames.\n", this.frameCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FramePacket getFramePacket() {
        FramePacket fp = null;
        if (this.fpQueue == null) return fp;
        List<FramePacket> list = this.fpQueue;
        synchronized (list) {
            while (this.fpQueue.isEmpty()) {
                try {
                    this.fpQueue.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return this.fpQueue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeys(byte keys, int frameNo) {
        if (this.kpQueue != null) {
            KeyPacket kp = this.comm.getKeyPacket();
            kp.setKeys(keys);
            kp.setTargetFameNo(frameNo);
            List<KeyPacket> list = this.kpQueue;
            synchronized (list) {
                if (this.kpQueue.isEmpty()) {
                    this.kpQueue.add(kp);
                    kp = null;
                } else {
                    ListIterator<KeyPacket> it = this.kpQueue.listIterator();
                    while (it.hasNext()) {
                        KeyPacket p = it.next();
                        int tfn = p.getTargetFameNo();
                        if (tfn == frameNo) {
                            p.setKeys(keys);
                            continue;
                        }
                        if (tfn <= frameNo) continue;
                        it.previous();
                        it.add(kp);
                        kp = null;
                    }
                }
            }
            if (kp != null) {
                this.comm.disposeKeyPacket(kp);
            }
        }
    }

    public int getGamesCompleted() {
        return this.gamesCompleted;
    }

    public void dumpKeyQueue() {
        this.comm.dumpKeyQueue();
    }

    private static String getStateString(int stat) {
        switch (stat) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "WAIT_START";
            }
            case 2: {
                return "WAIT_PLAY";
            }
            case 3: {
                return "PLAYING";
            }
            case 4: {
                return "GAME_OVER";
            }
            case 5: {
                return "HIGHSCORE";
            }
        }
        return "?????";
    }
}

