/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.ScreenVector;
import java.util.BitSet;

public class AngleTracker {
    private static final int[] rawCoords;
    private static int[] coordX;
    private static int[] coordY;
    private static BitSet[] angleSets;
    private static int[] screenAngles;
    private int screenAngle = 0;
    private int angle = 0;
    private BitSet angleSet = (BitSet)angleSets[0].clone();
    private boolean inSync = false;

    static {
        int[] nArray = new int[17];
        nArray[1] = 152;
        nArray[2] = 296;
        nArray[3] = 440;
        nArray[4] = 584;
        nArray[5] = 720;
        nArray[6] = 856;
        nArray[7] = 976;
        nArray[8] = 1088;
        nArray[9] = 1192;
        nArray[10] = 1280;
        nArray[11] = 1360;
        nArray[12] = 1416;
        nArray[13] = 1472;
        nArray[14] = 1504;
        nArray[15] = 1528;
        nArray[16] = 1536;
        rawCoords = nArray;
        coordX = new int[64];
        coordY = new int[64];
        angleSets = new BitSet[64];
        screenAngles = new int[256];
        System.out.print("Building angle tracker tables... ");
        int i = 0;
        while (i < 16) {
            AngleTracker.coordX[i] = rawCoords[16 - i];
            AngleTracker.coordY[i] = rawCoords[i];
            AngleTracker.coordX[i + 16] = -rawCoords[i];
            AngleTracker.coordY[i + 16] = rawCoords[16 - i];
            AngleTracker.coordX[i + 32] = -rawCoords[16 - i];
            AngleTracker.coordY[i + 32] = -rawCoords[i];
            AngleTracker.coordX[i + 48] = rawCoords[i];
            AngleTracker.coordY[i + 48] = -rawCoords[16 - i];
            ++i;
        }
        int sa = 0;
        while (sa < 64) {
            AngleTracker.angleSets[sa] = new BitSet(256);
            ++sa;
        }
        angleSets[0].set(0, 4);
        angleSets[0].set(253, 256);
        angleSets[16].set(64);
        angleSets[32].set(125, 132);
        angleSets[48].set(192);
        int a = 1;
        int i2 = 4;
        while (a < 16) {
            angleSets[a].set(i2, 4 + i2);
            angleSets[a + 16].set(61 + i2, 65 + i2);
            angleSets[a + 32].set(128 + i2, 132 + i2);
            angleSets[a + 48].set(189 + i2, 193 + i2);
            ++a;
            i2 += 4;
        }
        sa = 0;
        while (sa < 64) {
            BitSet set = angleSets[sa];
            int a2 = set.nextSetBit(0);
            while (a2 >= 0) {
                AngleTracker.screenAngles[a2] = sa;
                ++a2;
                a2 = set.nextSetBit(a2);
            }
            ++sa;
        }
        System.out.println("done.");
    }

    public int getAngle() {
        return this.angle;
    }

    public ScreenVector getDir() {
        return new ScreenVector(coordX[this.screenAngle], coordY[this.screenAngle]);
    }

    public boolean isInSync() {
        return this.inSync;
    }

    public void initializeAngle(int dx, int dy) {
        if (!AngleTracker.matchScreenAngle(this.screenAngle, dx, dy)) {
            this.screenAngle = 63;
            while (this.screenAngle >= 0) {
                if (AngleTracker.matchScreenAngle(this.screenAngle, dx, dy)) break;
                if (this.screenAngle == 0) {
                    System.out.printf("Screen angle initialization failed on (%d,%d)\n", dx, dy);
                    return;
                }
                --this.screenAngle;
            }
        }
        if ((this.screenAngle & 0x1F) == 16) {
            this.angle = this.screenAngle << 2;
            this.inSync = true;
        } else {
            this.angleSet = (BitSet)angleSets[this.screenAngle].clone();
            this.angle = this.angleSet.nextSetBit(0);
            this.inSync = false;
        }
    }

    public void updateAngle(int dx, int dy, int keys) {
        int a = this.angle;
        if (this.inSync) {
            if (dx == 0) {
                a = dy < 0 ? 192 : 64;
            } else if ((keys & 0x10) != 0) {
                a = a + 3 & 0xFF;
            } else if ((keys & 8) != 0) {
                a = a - 3 & 0xFF;
            }
            int sa = screenAngles[a];
            if (AngleTracker.matchScreenAngle(sa, dx, dy)) {
                this.angle = a;
                this.screenAngle = sa;
            } else if (!AngleTracker.matchScreenAngle(this.screenAngle, dx, dy)) {
                System.out.println("Screen angle mismatch");
                this.resynchAngle(dx, dy);
            }
        } else {
            this.synchronizeAngle(dx, dy, keys);
        }
    }

    private void resynchAngle(int dx, int dy) {
        int offs = 1;
        while (offs <= 128) {
            int a = this.angle + offs * 3 & 0xFF;
            int sa = screenAngles[a];
            if (AngleTracker.matchScreenAngle(sa, dx, dy)) {
                this.angle = a;
                this.screenAngle = sa;
                return;
            }
            a = this.angle - offs * 3 & 0xFF;
            sa = screenAngles[a];
            if (AngleTracker.matchScreenAngle(sa, dx, dy)) {
                this.angle = a;
                this.screenAngle = sa;
                return;
            }
            ++offs;
        }
        this.initializeAngle(dx, dy);
    }

    private void synchronizeAngle(int dx, int dy, int keys) {
        int i;
        BitSet set = new BitSet(256);
        int a = this.angle;
        if ((keys & 0x10) != 0) {
            a = a + 3 & 0xFF;
            i = this.angleSet.nextSetBit(0);
            while (i >= 0) {
                set.set(i + 3 & 0xFF);
                ++i;
                i = this.angleSet.nextSetBit(i);
            }
        } else if ((keys & 8) != 0) {
            a = a - 3 & 0xFF;
            i = this.angleSet.nextSetBit(0);
            while (i >= 0) {
                set.set(i - 3 & 0xFF);
                ++i;
                i = this.angleSet.nextSetBit(i);
            }
        } else {
            set.or(this.angleSet);
        }
        int sa = screenAngles[a];
        if (coordX[sa] != dx || coordY[sa] != dy) {
            System.out.println("Screen angle mismatch");
            this.inSync = false;
            sa = AngleTracker.resynchScreenAngle(sa, dx, dy);
            if (sa == screenAngles[a]) {
                return;
            }
            if (sa != this.screenAngle) {
                this.angleSet = (BitSet)angleSets[this.screenAngle].clone();
                this.screenAngle = sa;
            }
        } else {
            this.screenAngle = sa;
            this.angleSet = (BitSet)angleSets[this.screenAngle].clone();
            this.angleSet.and(set);
        }
        if (this.angleSet.get(a)) {
            this.angle = a;
            this.inSync = this.angleSet.cardinality() == 1;
        } else if (!this.angleSet.get(this.angle)) {
            a = this.angleSet.nextSetBit(0);
            if (a >= 0) {
                this.angle = a;
            } else {
                System.out.printf("Angle synchronization lost: %d\n", this.angle);
                this.inSync = false;
            }
        }
    }

    private static boolean matchScreenAngle(int sa, int dx, int dy) {
        return coordX[sa] == dx && coordY[sa] == dy;
    }

    private static int resynchScreenAngle(int sa, int dx, int dy) {
        int i = sa - 3;
        while (i <= sa + 60) {
            int sa_tmp = i & 0x3F;
            if (AngleTracker.matchScreenAngle(sa_tmp, dx, dy)) {
                return sa_tmp;
            }
            ++i;
        }
        System.out.printf("Cannot find screen angle for (%d,%d), even after full search\n", dx, dy);
        return sa;
    }

    private static String bitsetToString(BitSet set) {
        if (set.cardinality() == 0) {
            return " none";
        }
        StringBuilder strb = new StringBuilder();
        int i = set.nextSetBit(0);
        while (i >= 0) {
            strb.append(' ').append(i);
            ++i;
            i = set.nextSetBit(i);
        }
        return strb.toString();
    }
}

