/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.comm;

import de.heise.asteroid.comm.FramePacket;
import de.heise.asteroid.comm.KeyPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;

public class ServerConnection
extends Thread {
    public static final int SERVER_PORT = 1979;
    private DatagramSocket socket = new DatagramSocket();
    private InetAddress address;
    private List<FramePacket> fpPool;
    private List<KeyPacket> kpPool;
    private int fpCount;
    private int kpCount;
    private int packetsSent;
    private int packetsRcvd;

    public ServerConnection() throws SocketException {
        this.socket.setReceiveBufferSize(20520);
        this.fpPool = new LinkedList<FramePacket>();
        this.kpPool = new LinkedList<KeyPacket>();
        this.fpCount = 0;
        this.kpCount = 0;
        this.packetsSent = 0;
        this.packetsRcvd = 0;
    }

    public void connect(String serverName) throws UnknownHostException {
        this.address = InetAddress.getByName(serverName);
        this.socket.connect(this.address, 1979);
    }

    public void disconnect() {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FramePacket getFramePacket() {
        List<FramePacket> list = this.fpPool;
        synchronized (list) {
            if (this.fpPool.isEmpty()) {
                ++this.fpCount;
                return new FramePacket();
            }
            return this.fpPool.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeFramePacket(FramePacket fp) {
        List<FramePacket> list = this.fpPool;
        synchronized (list) {
            this.fpPool.add(fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPacket getKeyPacket() {
        List<KeyPacket> list = this.kpPool;
        synchronized (list) {
            if (this.kpPool.isEmpty()) {
                ++this.kpCount;
                return new KeyPacket();
            }
            return this.kpPool.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeKeyPacket(KeyPacket kp) {
        List<KeyPacket> list = this.kpPool;
        synchronized (list) {
            this.kpPool.add(kp);
        }
    }

    public FramePacket receive() throws IOException {
        FramePacket fp = this.getFramePacket();
        DatagramPacket datagramPacket = fp.getDatagramPacket();
        try {
            this.socket.receive(datagramPacket);
            fp.setTimeStamp(System.nanoTime());
            ++this.packetsRcvd;
        }
        catch (SocketTimeoutException e) {
            this.disposeFramePacket(fp);
            return null;
        }
        catch (IOException e) {
            System.err.println("Error receiving a frame packet: " + e.getMessage());
            throw e;
        }
        return fp;
    }

    public KeyPacket send(KeyPacket kp) {
        try {
            this.socket.send(kp.getDatagramPacket());
            ++this.packetsSent;
            this.disposeKeyPacket(kp);
            return null;
        }
        catch (IOException e) {
            System.err.println("Error sending a keys packet: " + e.getMessage());
            return kp;
        }
    }

    public int getPacketsSent() {
        return this.packetsSent;
    }

    public int getPacketsRcvd() {
        return this.packetsRcvd;
    }

    public int getFramePacketCount() {
        return this.fpCount;
    }

    public int getKeyPacketCount() {
        return this.kpCount;
    }
}

