/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid;

import de.heise.asteroid.util.SimpleMath;

public class ScreenVector {
    public static final ScreenVector NULL_VECTOR = new ScreenVector(0, 0);
    protected static int minX = -4096;
    protected static int maxX = 4096;
    protected static int minY = -3072;
    protected static int maxY = 3072;
    protected int x;
    protected int y;

    public ScreenVector(int dx, int dy) {
        this.x = dx;
        this.y = dy;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public ScreenVector sum(ScreenVector a) {
        return new ScreenVector(this.x + a.x, this.y + a.y);
    }

    public ScreenVector diff(ScreenVector a) {
        return new ScreenVector(this.x - a.x, this.y - a.y);
    }

    public int scalarProduct(ScreenVector a) {
        return this.x * a.x + this.y * a.y;
    }

    public int crossProduct2D(ScreenVector a) {
        return this.x * a.y - this.y * a.x;
    }

    public int sqAbs() {
        return this.x * this.x + this.y * this.y;
    }

    public double abs() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        this.x = SimpleMath.normalize(this.x, minX, maxX);
        this.y = SimpleMath.normalize(this.y, minY, maxY);
    }

    public static void setNormalization(int minx, int maxx, int miny, int maxy) {
        minX = minx;
        maxX = maxx;
        minY = miny;
        maxY = maxy;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.x).append(",").append(this.y);
        return str.toString();
    }
}

