/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.oflebbe.asteroids;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

/**
 *
 * @author olaf
 */
public class Screen {

    byte[] screenData;
    private ArrayList<Asteroid> asteroids;
    private ArrayList<Shot> shots;
    private Saucer saucer;
    private Ship ship;

    public Screen(byte[] screenData) {
        this.screenData = screenData;
        asteroids = new ArrayList<Asteroid>(8);
        shots = new ArrayList<Shot>(10);
        ship = null;
        interpret();
    }

    // Umwandeln von Bytes in Shorts
    private final int getShort(int pc) {
        return ((screenData[pc * 2 + 1] & 0xff) << 8) | (screenData[pc * 2] & 0xff);
    }

    private void interpret() {
        try {
        int pc = 1;
        int vx = 0, vy = 0, vs = 0, vz = 0;
        int shipDetect = 0;
        int dx, dy;
        int v1x = 0, v1y = 0;
        while (true) {
            int op = getShort(pc) >>> 12;
            switch (op) {
                case 0xa: // LABS
                    vy = getShort(pc) & 0x3ff;
                    vx = getShort(pc + 1) & 0x3ff;
                    vs = getShort(pc + 1) >>> 12;
                    // Bletch! Arghhh! 
                    if (vs > 5) {
                        vs = vs - 16;
                    } 
  
                            
                    break;
                case 0xb: // HALT
                    return;
                case 0xc: // JSRL
                    int instr = getShort(pc) & 0xfff;
                    switch (instr) {
                        case 0x8f3:
                        case 0x8ff:
                        case 0x90d:
                        case 0x91a:
                            // 20 geraten
                            asteroids.add(new Asteroid(vx, vy, 20 << ( vs + 2), instr));
                            break;

                        case 0x929:
                            saucer = new Saucer(vx, vy, vs);
                            break;

                    }
                    break;

                case 0xd: // RTSL
                case 0xe: // JMPL
                    return;
                case 0xf: // SVEC
                    break;
                default:
                    int inst = getShort(pc);
                    dy = inst & 0x3ff;
                    if ((inst & 0x400) != 0) {
                        dy = -dy;
                    }
                    inst = getShort(pc + 1);
                    dx = inst & 0x3ff;
                    if ((inst & 0x400) != 0) {
                        dx = -dx;
                    }

                    vz = inst >> 12;
                    if (dx == 0 && dy == 0 && vz == 15) {
                        getShots().add(new Shot(vx, vy));
                    }
                    if (op == 6 && vz == 12 && dx != 0 && dy != 0) {
                        switch (shipDetect) {
                            case 0:
                                v1x = dx;
                                v1y = dy;
                                ++shipDetect;
                                break;
                            case 1:
                                ship = new Ship(vx, vy, v1x - dx, v1y - dy);
                                ++shipDetect;
                                break;
                        }
                    } else if (shipDetect == 1) {
                        shipDetect = 0;
                    }
                    break;
            }
            if (op <= 0xa) {
                ++pc;
            }
            if (op != 0xe) // JMPL
            {
                ++pc;
            }
        }
        }catch (Exception e) {
            System.out.println("Exception!!");
        }
        
    }

    public ArrayList<Asteroid> getAsteroids() {
        return asteroids;
    }

    public ArrayList<Shot> getShots() {
        return shots;
    }

    public Ship getShip() {
        return ship;
    }

    public Saucer getSaucer() {
        return saucer;
    }
    
    public void save(PrintWriter p) throws IOException {
        p.println("---------------------------------");
        p.printf("# of Asteroids: %d\n", asteroids.size());
        for (Asteroid ast : asteroids) {
            p.printf( " %d %d, %f %f, %d\n", ast.getX(), ast.getY(), ast.getVx(), ast.getVy(), ast.getSize());
        }
        p.printf("# of Shots: %d\n", shots.size());
        for (Shot sho : shots) {
            p.printf( " %d %d, %f %f", sho.getX(), sho.getY(), sho.getVx(), sho.getVy());
            if (sho.isUfoShot()) {
                p.println("UFO");
            } else {
                p.println();
            }
        }
        if (saucer != null) {
            p.println("Saucer");
            p.printf( "%d %d, %f %f\n", saucer.getX(), saucer.getY(), saucer.getVx(), saucer.getVy());
        }
        if (ship != null) {
            p.println("Ship");
            p.printf( "%d %d, %f %f\n", ship.getX(), ship.getY(), ship.getVx(), ship.getVy());
        }   
        
        
    }
    
}
