/*
 * Decompiled with CFR 0.152.
 */
package de.oflebbe.asteroids;

import de.oflebbe.asteroids.Asteroid;
import de.oflebbe.asteroids.Keys;
import de.oflebbe.asteroids.MovingObject;
import de.oflebbe.asteroids.Saucer;
import de.oflebbe.asteroids.Screen;
import de.oflebbe.asteroids.Ship;
import de.oflebbe.asteroids.Shot;
import de.oflebbe.asteroids.Tacticvisualiser;
import de.oflebbe.asteroids.Vecd2D;
import java.awt.Color;
import java.awt.Graphics2D;

public class Tactic
implements Tacticvisualiser {
    private int minDist;
    boolean fired = false;
    int thruster = 0;
    static final double vshot = 8.0;
    private MovingObject target;
    private Vecd2D direct;
    private Ship ship = null;

    public Keys nextFrame(Screen current) {
        Saucer saucer;
        int size;
        Keys keys = new Keys();
        this.target = null;
        this.ship = current.getShip();
        if (this.ship == null) {
            return keys;
        }
        this.minDist = 0x100000;
        for (Asteroid ast : current.getAsteroids()) {
            int dist2 = ast.len2(this.ship);
            if (dist2 >= this.minDist) continue;
            this.minDist = dist2;
            this.target = ast;
        }
        if (this.target != null && this.minDist < (size = ((Asteroid)this.target).getSize() + 10) * size) {
            keys.setHyperspace(true);
        }
        if ((saucer = current.getSaucer()) != null && saucer.len2(this.ship) < this.minDist) {
            this.target = saucer;
        }
        for (Shot s : current.getShots()) {
            double dvy;
            if (keys.isHyperspace()) break;
            if (!(this.closestDistance2(this.ship, s, 2.0) < 400.0)) continue;
            int rx = s.getX() - this.ship.getX();
            int ry = s.getY() - this.ship.getY();
            double dvx = s.getVx();
            if (!((double)rx * dvx + (double)ry * (dvy = s.getVy()) < 0.0)) continue;
            keys.setHyperspace(true);
        }
        if (this.target == null) {
            return keys;
        }
        if (this.fired) {
            this.fired = !this.fired;
        } else {
            Shot testShot = new Shot(this.ship);
            testShot.setVx(this.ship.getVx() + (double)(8 * this.ship.getDx()));
            testShot.setVy(this.ship.getVy() + (double)(8 * this.ship.getDy()));
            for (Asteroid ast : current.getAsteroids()) {
                double dist = ast.getSize() + 10;
                if (!(this.closestDistance2(testShot, ast, 40.0) < dist * dist)) continue;
                this.fired = true;
                break;
            }
            if (saucer != null && this.closestDistance2(testShot, saucer, 40.0) < 2500.0) {
                this.fired = true;
            }
        }
        keys.setFire(this.fired);
        this.direct = new Vecd2D();
        Ship nextShip = new Ship(this.ship);
        nextShip.setV(this.ship.getV());
        nextShip.add(this.ship.getV().d2i());
        MovingObject nextTarget = new MovingObject(this.target);
        nextTarget.setV(this.target.getV());
        nextTarget.add(this.target.getV().d2i());
        if (!Tactic.shotDirection(nextShip, nextTarget, this.direct)) {
            return keys;
        }
        if (this.direct.getX() * (double)this.ship.getDy() - this.direct.getY() * (double)this.ship.getDx() > 0.0) {
            keys.setRight(true);
        } else {
            keys.setLeft(true);
        }
        if (this.target.getVx() * this.ship.getVx() + this.target.getVy() * this.ship.getVy() >= 0.0) {
            ++this.thruster;
            keys.setThrust(this.thruster % 3 == 0);
        }
        return keys;
    }

    private double closestTime(MovingObject source, MovingObject target) {
        int dry = target.getY() - source.getY();
        int drx = target.getX() - source.getX();
        double dvx = source.getVx() - target.getVx();
        double dvy = source.getVy() - target.getVy();
        return ((double)drx * dvx + (double)dry * dvy) / (dvx * dvx + dvy * dvy);
    }

    private double closestDistance2(MovingObject source, MovingObject target, double cutoff) {
        double time = this.closestTime(source, target);
        if (time < 0.0) {
            time = 0.0;
        }
        if (time > cutoff) {
            time = cutoff;
        }
        double rtx = (double)source.getX() + time * source.getVx() - (double)target.getX() - time * target.getVx();
        double rty = (double)source.getY() + time * source.getVy() - (double)target.getY() - time * target.getVy();
        return rtx * rtx + rty * rty;
    }

    private static boolean shotDirection(Ship ship, MovingObject target, Vecd2D direct) {
        int dry = target.getY() - ship.getY();
        int drx = target.getX() - ship.getX();
        double dvx = ship.getVx() - target.getVx();
        double dvy = ship.getVy() - target.getVy();
        double termA = ((double)drx * dvy - (double)dry * dvx) / 8.0;
        double term2 = (double)drx * Math.sqrt((double)(drx * drx + dry * dry) - termA * termA);
        double cosa1 = ((double)dry * termA + term2) / (double)(dry * dry + drx * drx);
        double cosa2 = ((double)dry * termA - term2) / (double)(dry * dry + drx * drx);
        double dt1 = (double)drx / (dvx + 8.0 * cosa1);
        double dt2 = (double)drx / (dvx + 8.0 * cosa2);
        if (dt1 < 0.0 && dt2 < 0.0) {
            return false;
        }
        double cosa = dt1 > 0.0 && dt2 < 0.0 ? cosa1 : (dt1 < 0.0 && dt2 > 0.0 ? cosa2 : (dt1 < dt2 ? cosa1 : cosa2));
        double sina1 = Math.sqrt(1.0 - cosa * cosa);
        double dt3 = (double)dry / (dvy + 8.0 * sina1);
        double dt4 = (double)dry / (dvy - 8.0 * sina1);
        if (dt3 < 0.0 && dt4 < 0.0) {
            return false;
        }
        double sina = dt3 > 0.0 && dt4 < 0.0 ? sina1 : (dt3 < 0.0 && dt4 > 0.0 ? -sina1 : (dt3 < dt4 ? sina1 : -sina1));
        direct.setX(cosa);
        direct.setY(sina);
        return true;
    }

    public void visualiseTactic(Graphics2D g2) {
        if (this.target != null) {
            g2.setPaint(new Color(1.0f, 0.0f, 0.0f));
            g2.drawOval(this.target.getX() - 25, this.target.getY() - 25, 50, 50);
        }
        if (this.ship != null) {
            g2.drawLine(this.ship.getX(), this.ship.getY(), this.ship.getX() + (int)(100.0 * this.direct.getX()), this.ship.getY() + (int)(100.0 * this.direct.getY()));
        }
    }
}

