#include "ruby.h"
#include <math.h>
extern VALUE rb_cArray;

#define Need_Float(x) if(TYPE(x)!=T_FLOAT) (x) = rb_Float(x)
#define Need_Float2(x,y) do {\
    Need_Float(x);\
    Need_Float(y);\
} while (0)

#define F(x) (RFLOAT(x)->value)

#define UNPCK_F2(ary,x0,x1)                             \
  Need_Float2(RARRAY(ary)->ptr[0],RARRAY(ary)->ptr[1]); \
  VALUE x0    = RARRAY(ary)->ptr[0];                    \
  VALUE x1    = RARRAY(ary)->ptr[1];

VALUE full_dup(VALUE ary)
{
  UNPCK_F2(ary,x0,x1);
  VALUE dup = rb_ary_new2(2);
  RARRAY(dup)->ptr[0] = rb_float_new(F(x0));
  RARRAY(dup)->ptr[1] = rb_float_new(F(x1));
  RARRAY(dup)->len    = 2;
  return dup;
}

//  def abs()  Math.sqrt(self[0]*self[0]+self[1]*self[1])               end
VALUE rb_ary_abs(VALUE self)
{
  UNPCK_F2(self,x0,x1);
  double fabs = sqrt(F(x0)*F(x0) + F(x1)*F(x1));
  return  rb_float_new(fabs);
}
//  def ang360() Math.atan2(self[1],self[0])*180/Math::PI%360 end
VALUE rb_ary_ang360(VALUE self)
{
  UNPCK_F2(self,x0,x1);
  double ang = atan2( F(x1), F(x0))*180/M_PI;
  if(ang < 0)  ang += 360;
  return  rb_float_new(ang);
}
VALUE rb_ary_norm_q(int argc, VALUE*argv, VALUE self)
{
  double fabs = 1;
  if (argc == 1) {
    VALUE y = argv[0];
    Need_Float(y);
    fabs = RFLOAT(y)->value;   
  }
  if (argc > 1) {
    rb_raise(rb_eArgError, "wrong number of arguments (%d > 1)", argc);
  }
  UNPCK_F2(self,x0,x1);
  fabs  /= sqrt(F(x0)*F(x0) + F(x1)*F(x1));
  F(x0) *= fabs;   
  F(x1) *= fabs;   
  return self;
}
VALUE rb_ary_norm(int argc, VALUE*argv, VALUE self)
{
  return rb_ary_norm_q(argc,argv,full_dup(self));
}
VALUE rb_ary_mul_q(VALUE self, VALUE y )
{
  Need_Float(y);
  UNPCK_F2(self,x0,x1);
  F(x0) *= F(y);   
  F(x1) *= F(y);   
  return self;
}
VALUE rb_ary_mul(VALUE self, VALUE y)
{
  return rb_ary_mul_q(full_dup(self),y);
}
VALUE rb_ary_div_q(VALUE self, VALUE y )
{
  Need_Float(y);
  UNPCK_F2(self,x0,x1);
  F(x0) /= F(y);   
  F(x1) /= F(y);   
  return self;
}
VALUE rb_ary_div(VALUE self, VALUE y)
{
  return rb_ary_div_q(full_dup(self),y);
}

VALUE rb_ary_add_q(VALUE self, VALUE ary )
{
  UNPCK_F2(self,x0,x1);
  UNPCK_F2(ary,y0,y1);
  F(x0) += F(y0);   
  F(x1) += F(y1);   
  return self;
}
VALUE rb_ary_add(VALUE self, VALUE ary)
{
  return rb_ary_add_q(full_dup(self),ary);
}

VALUE rb_ary_addmul(VALUE self, VALUE ary, VALUE f)
{
  self=full_dup(self);
  UNPCK_F2(self,x0,x1);
  UNPCK_F2(ary,y0,y1);
  Need_Float(f);
  F(x0) += F(y0)*F(f);   
  F(x1) += F(y1)*F(f);   
  return self;
}

VALUE rb_ary_sub_q(VALUE self, VALUE ary )
{
  UNPCK_F2(self,x0,x1);
  UNPCK_F2(ary,y0,y1);
  F(x0) -= F(y0);   
  F(x1) -= F(y1);   
  return self;
}
VALUE rb_ary_sub(VALUE self, VALUE ary)
{
  return rb_ary_sub_q(full_dup(self),ary);
}
VALUE rb_ary_ip(VALUE self, VALUE ary )
{
  UNPCK_F2(self,x0,x1);
  UNPCK_F2(ary,y0,y1);
  return  rb_float_new(F(x0)*F(y0) + F(x1)*F(y1) );
}
VALUE rb_ary_kp(VALUE self, VALUE ary )
{
  UNPCK_F2(self,x0,x1);
  UNPCK_F2(ary,y0,y1);
  return  rb_float_new(F(x0)*F(y1) - F(x1)*F(y0) );
}
VALUE rb_ary_rot90(VALUE self )
{
  UNPCK_F2(self,x0,x1);
  VALUE dup = rb_ary_new2(2);
  RARRAY(dup)->ptr[0] = rb_float_new(F(x1));
  RARRAY(dup)->ptr[1] = rb_float_new(-F(x0));
  RARRAY(dup)->len    = 2;
  return dup;
}
void Init_vector2()
{
  rb_define_method(rb_cArray, "abs",   rb_ary_abs, 0);
  rb_define_method(rb_cArray, "ang360",rb_ary_ang360, 0);
  rb_define_method(rb_cArray, "norm!", rb_ary_norm_q, -1);
  rb_define_method(rb_cArray, "norm",  rb_ary_norm,   -1);
  rb_define_method(rb_cArray, "mul!",  rb_ary_mul_q,   1);
  rb_define_method(rb_cArray, "mul",   rb_ary_mul,     1);
  rb_define_method(rb_cArray, "div!",  rb_ary_div_q,   1);
  rb_define_method(rb_cArray, "div",   rb_ary_div,     1);
  rb_define_method(rb_cArray, "add!",  rb_ary_add_q,   1);
  rb_define_method(rb_cArray, "add",   rb_ary_add,     1);
  rb_define_method(rb_cArray, "addmul",rb_ary_addmul,  2);
  rb_define_method(rb_cArray, "sub!",  rb_ary_sub_q,   1);
  rb_define_method(rb_cArray, "sub",   rb_ary_sub,     1);
  rb_define_method(rb_cArray, "ip",    rb_ary_ip,      1);
  rb_define_method(rb_cArray, "kp",    rb_ary_kp,      1);
  rb_define_method(rb_cArray, "rot90", rb_ary_rot90,   0);
}
