// c't Programmierwettbewerb Asteroids Juni 2008
// Maurer Christoph	christoph_m@gmx.net


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#define _USE_MATH_DEFINES
#include <math.h>
#include <winsock2.h>

#include "player.h"
//#define LOGGING 

#define USE_WBYTE

int wbyte_i=0; // Winkelbyteindex

void Player::Run(bool log)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus game;
	char prevframe = 0;
	int t = 0;
	int last_t = 0;
	int fire_speed = 2;
	bool schiff_gesichtet = false;
	bool ufo_gesichtet = false;
	bool cmp_2frames_possible = false; 
	bool cmp_2frames_ufo_possible = false;
	int last_wbyte_i=0;
	int last_dx = 1536;
	int last_dy = 0;
	int frames_lost = 0;
	enum TURN {TURN_LEFT=1,TURN_RIGHT=-1,TURN_NO=0};
	TURN turn=TURN_NO;
	int nop_turn_cnt = 1;
	int wbyte_change = 0;

	while(true)
	{
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);

		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			frames_lost = frame.frameno-prevframe;//keys.ping - frame.ping;//frame.frameno - prevframe;
			printf("Latenz %d. %d Frames verloren. diff=%d\n", keys.ping - frame.ping, frame.frameno - prevframe,frames_lost);
			prevframe = frame.frameno;
			wbyte_change+=turn*frames_lost;
			fflush(stdout);

		}
		else{
			frames_lost = 0;
			last_t = t;
		}

		InterpretScreen(frame, game);

		if(cmp_2frames_possible){
			if(game.cmp_2frames()){
				
				game.calc_vec_2frames();
				if(log){
					puts("### neue asteroiden ###");
					puts("Asteroiden Array scheint ok zu sein!");
					game.print_asteroids(false);
				}
			}
			else{
				cmp_2frames_possible = false;
			}

			for(int i=0;i<game.nasteroids;i++){
				if(game.asteroids[i].destroyed>0.0f)
					game.asteroids[i].destroyed--;
			}
		}
		else{
			game.p = 0;
			for(int i=0;i<game.nasteroids;i++){
				game.asteroids[i].destroyed = 0.0f;
			}
		}

		if(cmp_2frames_ufo_possible){
			game.calc_vec_ufo_2frames();
		}
		else{
			game.ufo_p = 0;
		}

		keys.clear();   // alle Tasten loslassen
		int min_dist = 0x7fffffff;
		int min_dx = 0;
		int min_dy = 0;
		
		if(log){
			game.print_asteroids(true);
			game.print_shots(true);
		}
		if(last_dx!=game.ship_dx || last_dy!=game.ship_dy){	
			wbyte_i +=wbyte_change;
			wbyte_change = 0;
			while(wbyte_i>255) 
				wbyte_i-=256;
			while(wbyte_i<0) 
				wbyte_i+=256;
			game.set_ship_angle(wbyte[wbyte_i]);
		}
		else {
			wbyte_i = last_wbyte_i;
			game.set_ship_angle(wbyte[wbyte_i]);
		}

		if (game.ship_present)
		{
			if(log)
				game.print_ship(true);
			if(!schiff_gesichtet){
				//printf("Schiff gesichtet!\n");
				schiff_gesichtet = true;
			}

			if(game.ufo_present)
			{
				if(log)
					game.print_ufo(true);
				if(!ufo_gesichtet){
					ufo_gesichtet = true;
					//printf("UFO gesichtet (%d|%d)\n",game.ufo_x,game.ufo_y);
				}
				game.ufo_size_old = game.ufo_size;
				game.ufo_x_old = game.ufo_x;
				game.ufo_y_old = game.ufo_y;
				cmp_2frames_ufo_possible = true;
			}
			else
			{
				cmp_2frames_ufo_possible = false;
				if(ufo_gesichtet)
				{
					ufo_gesichtet = false;
					//printf("Kein UFO mehr in Sicht\n");
				}
			}
			

			last_wbyte_i = wbyte_i;
			last_dx = game.ship_dx;
			last_dy = game.ship_dy;

			min_dist = game.find_min_dist();
			if (min_dist < 27*27)  {// Flucht, wenn Kollision unausweichlich
					keys.hyperspace(true);
			}
			else if(cmp_2frames_possible) // Abschusslogik
			{
				double rotation = game.turn_to_next_target(cmp_2frames_ufo_possible);
				if(log)
					game.dctx.print_destroy_context(true);
				
				if(rotation<-game.shot_precision){
					keys.right(true);
					//wbyte_i--;
					wbyte_change--;
					turn = TURN_RIGHT;
				}else if(rotation>game.shot_precision){
					keys.left(true);
					//wbyte_i++;
					wbyte_change++;
					turn = TURN_LEFT;
				}else {
					turn = TURN_NO;
					if (t % fire_speed ==0)  {
						keys.fire(true);
						if(game.dctx.ast_i!=-1){
							if(game.asteroids[game.dctx.ast_i].sf==14) // auf kleine asteroiden nicht mehrmals schieen
								game.asteroids[game.dctx.ast_i].destroyed = (float)game.dctx.t;
						}
					}
				}
			}
		}
		else  // Schiff ist nicht da
		{
			//wbyte_change = 0;
			if(schiff_gesichtet)
			{
				schiff_gesichtet = false;
				//printf("Kein Schiff mehr in Sicht\n");
			}
		}

		memcpy(game.asteroids_alt,game.asteroids,sizeof(Asteroid)*game.nasteroids);
		game.nasteroids_alt = game.nasteroids;
		cmp_2frames_possible = true;
		
		if(log)
			printf(">eof\n");// end of frame
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	game.clear();
	if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				game.ufo_present = true;
				game.ufo_x = vx;
				game.ufo_y = vy;
				game.ufo_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}
bool GameStatus::cmp_2frames(void) // Prft ob sich das Asteroidenarray asteroids[] verndert hat
{
	int i;
	int cnt = (nasteroids_alt<nasteroids)?nasteroids_alt:nasteroids;
	bool rv = true;
	if(nasteroids_alt!=nasteroids)
	{
		//printf("asteroiden anzahl hat sich geaendert\n");
		rv = false;
	}
	
	for(i=0;i<cnt && rv;i++)
	{
		if(asteroids_alt[i].sf!=asteroids[i].sf && asteroids_alt[i].type!=asteroids[i].type)
		{
		//	puts("asteroiden array hat sich geaendert");
		//	printf("...\nAsteroid[%d] (%d|%d) type=%d sf=%d\n",i,asteroids[i].x,asteroids[i].y,asteroids[i].type,asteroids[i].sf);
		//	printf("Asteroid_alt[%d] (%d|%d) type=%d sf=%d\n...\n",i,asteroids_alt[i].x,asteroids_alt[i].y,asteroids_alt[i].type,asteroids_alt[i].sf);
			//system("pause");
			rv = false;
		}
	}
	if(!rv){
		p=0;
		for(i=0;i<nasteroids;i++){
			asteroids[i].destroyed = 0.0f;
		}

	}
	return rv;
}

// Berechnet die Geschwindigkeitsvektoren durch vergleichen von Frames
void GameStatus::calc_vec_2frames(void)
{
	int i;
	int delta_x,delta_y;
	int cnt = (nasteroids_alt<nasteroids)?nasteroids_alt:nasteroids;

	
	if(p>1000) //eventuellen berlauf vermeiden
		p = 100;

	for(i=0;i<cnt;i++)
	{
		//todo: koordinatensystem anpassen!
		delta_x = asteroids[i].x - asteroids_alt[i].x;
		delta_y = asteroids[i].y - asteroids_alt[i].y;
		
		if(delta_x<50 && delta_x>-50 && delta_y<50 && delta_y>-50)  // bertritt ber den seitenrand nicht als geschwindigkeit messen
		{
			asteroids[i].vx = (float)(asteroids[i].vx*p + delta_x)/(float)(p+1);
			asteroids[i].vy = (float)(asteroids[i].vy*p + delta_y)/(float)(p+1);
			
		}	
	}
	p++;
}

void GameStatus::calc_vec_ufo_2frames(void)
{
	int delta_x,delta_y;
	
	delta_x = ufo_x - ufo_x_old;
	delta_y = ufo_y - ufo_y_old;

	if(ufo_p>50)
		ufo_p = 0;

	if(delta_x<50 && delta_x>-50 && delta_y<50 && delta_y>-50)
	{
		ufo_vx = (float)(ufo_vx*ufo_p + delta_x)/(float)(ufo_p+1);
		ufo_vy = (float)(ufo_vy*ufo_p + delta_y)/(float)(ufo_p+1);
		ufo_p++;
	}
}

int GameStatus::find_min_dist(void)
{
	int min_dist = 0x7fffffff;
	int min_dx = 0;
	int min_dy = 0;
	for (int i=0; i<this->nasteroids; ++i)
	{   // nchstgelegenen Asteroiden suchen
		int dx = this->asteroids[i].x - this->ship_x;
		while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
		while (dx > 511) dx -= 1024;
		int dy = this->asteroids[i].y - this->ship_y;
		while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
		while (dy > 383) dy -= 768;
		int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
		switch (this->asteroids[i].sf)
		{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
			case 0:  // groer Asteroid
				dist -= 40*40;
				break;
			case 15: // mittlerer Asteroid
				dist -= 20*20;
				break;
			case 14: // kleiner Asteroid
				dist -= 8*8;
				break;
		}
		if (dist < min_dist)
		{
			min_dist = dist;
			min_dx = dx;
			min_dy = dy;
		}
	}
	if (this->ufo_present)
	{
		int dx = this->ufo_x - this->ship_x;
		while (dx < -512) dx += 1024;
		while (dx > 511) dx -= 1024;
		int dy = this->ufo_y - this->ship_y;
		while (dy < -384) dy += 768;
		while (dy > 383) dy -= 768;
		int dist = dx*dx+dy*dy;
		switch (this->ufo_size)
		{	// Abstand um den ungefhren Radius des UFOs korrigieren
		case 15: // groes UFO
			dist -= 20*12;
			break;
		case 14: // kleines UFO
			dist -= 10*6;
			break;
		}
		if (dist < min_dist)
		{
			min_dist = dist;
			min_dx = dx;
			min_dy = dy;
		}
	}

	return min_dist;
}

double GameStatus::turn_to_next_target(bool ufo)
{
	double min = 180.1f;
	double mint = 1000000.0f;
#ifndef USE_WBYTE
	double ship_angle = (double)atan2((double)ship_dy,(double)ship_dx)*180.0f/M_PI;
#endif
#define UFO_PREFER_FRAMES 45 
	double a,b,t,alpha;
	int x,y,xq,yq;
	float vx,vy;
	float vxq,vyq;
	float speed = 63.5f;
	double diff,factor;
	int destroy_asteroid_i=-1;
	double destroy_time;
	shot_precision = 2.0f;

	if(ufo)
	{
		x = ufo_x-ship_x;
		while (x < -512) x += 1024; 
		while (x > 511) x -= 1024;
		y = ufo_y-ship_y;
		while (y < -384) y += 768;  
		while (y > 383) y -= 768;
		xq = x*x;
		yq = y*y;
		vx = ufo_vx;
		vy = ufo_vy;
		vxq = vx*vx;
		vyq = vy*vy;

		t=-(sqrt(-(vyq-speed)*xq+2*vx*vy*x*y-(vxq-speed)*yq)+vx*x+vy*y)/(vxq+vyq-speed);
		a = (x+vx*t)/t;
		b = (y+vy*t)/t;
		alpha = atan2(b,a)*180.0f/M_PI;

		diff = alpha - ship_angle;
			      
		if(fabs(diff)>180)
		{
			factor =  (diff>0)?-1.0f:1.0f;
			diff = (360 - fabs(diff))*factor;
		}     
		mint = t+fabs(diff/4.5)-UFO_PREFER_FRAMES;
		min = diff;
		dctx.angle = min;
		dctx.a = a;
		dctx.b = b;
		dctx.t = t;
		dctx.ship_x = ship_x;
		dctx.ship_y = ship_y;
		dctx.ast_i = -1;
	}
	for(int i=0;i<nasteroids;i++)
	{
		if(asteroids[i].destroyed>0.0f && nasteroids>1)
			continue;

		x = asteroids[i].x-ship_x;
		while (x < -512) x += 1024; 
		while (x > 511) x -= 1024;
		y = asteroids[i].y-ship_y;
		while (y < -384) y += 768;  
		while (y > 383) y -= 768;
		xq = x*x;
		yq = y*y;
		vx = asteroids[i].vx;
		vy = asteroids[i].vy;
		vxq = vx*vx;
		vyq = vy*vy;

		t=-(sqrt(-(vyq-speed)*xq+2*vx*vy*x*y-(vxq-speed)*yq)+vx*x+vy*y)/(vxq+vyq-speed);
		a = (x+vx*t)/t;
		b = (y+vy*t)/t;
		alpha = atan2(b,a)*180.0f/M_PI;

		diff = alpha - ship_angle;
			      
		if(fabs(diff)>180)
		{
			factor =  (diff>0)?-1.0f:1.0f;
			diff = (360 - fabs(diff))*factor;
		}     
		
		/*
		if(abs(diff)<min)
			min = diff;
		*/
		//if(abs(diff)<min && t<120)//if(t<mint)
		destroy_time = t+fabs(diff/4.5);
		if(destroy_time<mint)
		{
			mint = destroy_time;///*t+*/fabs(diff/4.5);
			min = diff;
			dctx.angle = min;
			dctx.a = a;
			dctx.b = b;
			dctx.t = t;
			dctx.ship_x = ship_x;
			dctx.ship_y = ship_y;
			dctx.asteroid.set(asteroids[i].x,asteroids[i].y,asteroids[i].type,asteroids[i].sf);
			dctx.ast_i = i;
			switch(asteroids[i].sf){
				case 0: shot_precision = 4.0; break;
				case 15: shot_precision = 2.8; break;
				case 14: shot_precision = 1.8; break;
			}
		}
	}
	return min;
}

double GameStatus::calc_coliding_angle(int ast_idx)
{
	double rv=0.0;
	/*double a,b,t,alpha;
	int x,y,xq,yq;
	float vx,vy;
	float vxq,vyq;

	x = asteroids[ast_idx].x-ship_x;
	while (x < -512) x += 1024; 
	while (x > 511) x -= 1024;
	y = asteroids[ast_idx].y-ship_y;
	while (y < -384) y += 768;  
	while (y > 383) y -= 768;
	xq = x*x;
	yq = y*y;
	vx = asteroids[ast_idx].vx;
	vy = asteroids[ast_idx].vy;
	vxq = vx*vx;
	vyq = vy*vy;
	speed = sqrt(vxq+vxq);

	t=-(sqrt(-(vyq-speed)*xq+2*vx*vy*x*y-(vxq-speed)*yq)+vx*x+vy*y)/(vxq+vyq-speed);
	a = (x+vx*t)/t;
	b = (y+vy*t)/t;
	alpha = atan2(b,a)*180.0f/M_PI;

	diff = alpha - ship_angle;
*/

	return rv;
}
void GameStatus::set_ship_angle(float angle)
{
	ship_angle = angle;
	if(ship_angle>180.0){
		ship_angle = ship_angle-360;
	}
	else if(ship_angle<-180.0){
		ship_angle = 360+ship_angle;
	}
}
void DestroyContext::print_destroy_context(bool draw)
{
	if(draw)
		printf(">dctx %d %d %f %f %f %f %d %d\n",asteroid.x,asteroid.y,a,b,t,angle,ship_x,ship_y);
	else
		printf("dctx %d %d %f %f %f %f %d %d\n",asteroid.x,asteroid.y,a,b,t,angle,ship_x,ship_y);
}

GameStatus::GameStatus(void)
{
	p = 0;
	//set_ship_angle(wbyte[wbyte_i]);
}

void GameStatus::print_asteroids(bool draw)
{
	int i;
	for(i=0;i<nasteroids;i++)
	{
		if(draw)
			printf(">ast %d %d %d %d %d %f %f\n",i,asteroids[i].x,asteroids[i].y,asteroids[i].type,asteroids[i].sf,asteroids[i].vx,asteroids[i].vy);
		else
			printf("Asteroid[%d] (%d|%d) type=%d sf=%d vx=%f vy=%f\n",i,asteroids[i].x,asteroids[i].y,asteroids[i].type,asteroids[i].sf,asteroids[i].vx,asteroids[i].vy);
	}
}

void GameStatus::print_shots(bool draw)
{
	int i;
	for(i=0;i<nshots;i++)
	{
		if(draw)
			printf(">shot %d %d %d\n",i,shots[i].x,shots[i].y);
		else
			printf("Shot[%d] (%d|%d)\n",i,shots[i].x,shots[i].y);
	}
}

void GameStatus::print_ufo(bool draw)
{
	if(ufo_present)
	{
		if(draw)
			printf(">ufo %d %d %d %f %f\n",ufo_x,ufo_y,ufo_size,ufo_vx,ufo_vy);
		else
			printf("Ufo (%d|%d) size=%d dx=%f dy=%f\n",ufo_x,ufo_y,ufo_size,ufo_vx,ufo_vy);
	}
}

void GameStatus::print_ship(bool draw)
{
	if(ship_present)
	{
		if(draw)
			printf(">ship %d %d %d %d %f %f %f\n",ship_x,ship_y,ship_dx,ship_dy,0.0f,0.0f,ship_angle);
		else
			printf("ship x=%d y=%d dx=%d dy=%d vx=%f vy=%f angle=%f\n",ship_x,ship_y,ship_dx,ship_dy,0.0f,0.0f,ship_angle);
	}
}
void GameStatus::clear(void)
{
	ship_present = false;
	ufo_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select((int)(sd+1), &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select((int)(sd+1), &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
	}
}
