// c't Programmierwettbewerb Asteroids Juni 2008
// Maurer Christoph	christoph_m@gmx.net


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <winsock2.h>
#include "player.h"

void welcome(void)
{
	puts("Programmierwettbewerb zum 25. c't-Geburtstag");
	printf("C++ Bot(Build: %s/%s) von Maurer Christoph (mauralix im heise Forum) christoph_m@gmx.net\n\n",__DATE__,__TIME__);
}


int main(int argc, char* argv[])
{
	bool log = false;
	welcome();
	if (argc < 2)
	{
		fprintf(stderr, "Aufruf: %s <IP-Adresse> [log]\nLogging nicht im Wettbewerb einschalten sondern nur in Kombination mit dem Displayprogramm!\n",argv[0]);
		exit(1);
	}
	unsigned long server_ip = inet_addr(argv[1]);
	if (server_ip == INADDR_NONE)
	{
		fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", argv[1]);
		exit(1);
	}
	if(argc==3){
		log = true;
	}

	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
		exit(2);
	}

	SOCKET sd;
	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sd == INVALID_SOCKET)
	{
		fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
		exit(2);
	}

	unsigned long enable_nonblocking = 1;
	if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
	{
		fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
		exit(1);
	}
	sockaddr_in sa;
	memset(&sa, 0, sizeof sa);
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port = 0;

	if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
	{
		fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
		exit(2);
	}

	Player player(sd, server_ip);
	player.Run(log);

	return 0;
}
