package util;

import java.awt.Graphics2D;
import java.io.Serializable;

public class Vector2D implements Comparable<Vector2D>, Serializable {
	
	private static final long serialVersionUID = 1L;
	
	
	public float x;
	public float y;
	
	
	public Vector2D() {
		x = 0;
		y = 0;
	}
	
	
	public Vector2D(float x, float y) {
		this.x = x;
		this.y = y;
	}
	
	
	public void add(Vector2D t) {
		x += t.x;
		y += t.y;
	}
	
	
	public void subtract(Vector2D t) {
		x -= t.x;
		y -= t.y;
	}
	
	
	public void multiply(float f) {
		x *= f;
		y *= f;
	}
	
	
	public float getLength() {
		return (float)Math.sqrt(x*x + y*y);
	}
	
	
	public boolean equals(Object v) {
		if (v instanceof Vector2D) {
			Vector2D w = (Vector2D) v;
			return x == w.x && y == w.y;
		} else {
			return false;
		}
	}
	
	
	public float getDeg() {
		float len = getLength();
		float px = x / len;
		float phi = (float)(Math.asin(px)*180.0f/Math.PI);
		if(x >= 0 && y <= 0) phi = 180 - phi;
		else if(x <= 0 && y <= 0) phi = 180 - phi;
		else if(x < 0 && y >= 0) phi = 360 + phi;
		return phi;
	}
	
	
	public float calcDifAngle(Vector2D v) {
		float p1 = getDeg();
		float p2 = v.getDeg();
		
		float d = p2 - p1;
		if(d < -180) d += 360;
		if(d > 180)  d -= 360;
		
		return d;
	}
	
	
	public void drawVector(Graphics2D g, int x, int y, float stretch) {
		int x2 = x + Math.round(this.x*stretch);
		int y2 = y + Math.round(this.y*stretch);
		g.drawLine(x, y, x2, y2);
	}
	
	
	public String toString() {
		return String.format("v=(%5.2f|%5.2f) |v|=%5.2f phi=%.2f", x, y, getLength(), getDeg());
	}
	

	public int compareTo(Vector2D v) {
		if(getDeg() > v.getDeg())
			return 1;
		else
			return 0;
	}

}
