package core.asteroid;

import java.awt.Color;
import java.util.ArrayList;

import core.opCodes.OpLocation;
import core.opCodes.OpVector;

public class Asteroid extends AsteroidObject {
	
	public static final int SIZE_LARGE	= 1;
	public static final int SIZE_MEDIUM = 2;
	public static final int SIZE_SMALL	= 3;
	
	
	private int size;
	

	public Asteroid(OpLocation location, ArrayList<OpVector> vectors) {
		super(location, vectors);
		
		if(hitRadius < 15) size = SIZE_SMALL;
		else if(hitRadius < 30) size = SIZE_MEDIUM;
		else size = SIZE_LARGE;
	}
	
	
	public String getObjectName() {
		if(size == SIZE_LARGE) return "Asteroid (gr)";
		else if(size == SIZE_MEDIUM) return "Asteroid (mi)";
		else return "Asteroid (kl)";
	}
	
	
	public int getSize() {
		return size;
	}


	public Color getDefaultColor() {
		return Color.LIGHT_GRAY;
	}
	
	
	public boolean isDestroyable() {
		return true;
	}
	
	
	public boolean hasCollision() {
		return true;
	}
}
