// afipsbot.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

#include "stdafx.h"
#include "afipsbot.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

/////////////////////////////////////////////////////////////////////////////
// Das einzige Anwendungsobjekt

CWinApp theApp;

using namespace std;

  

void initialize() {

  Player *m_player = NULL;
  int version = 2;  // version=1 intern; version=2 extern
	
  CString ipaddr = "127.0.0.1";
 // CString ipaddr = "192.168.2.170";  //lara3 XP
 // CString ipaddr = "192.168.2.151"; //lara2 ME
 // CString ipaddr = "193.99.145.178"; // asteroids.heise.de (193.99.145.178)

  CCommandLineInfo cl;
  theApp.ParseCommandLine(cl);

  if (! cl.m_strFileName.IsEmpty()) {
    ipaddr = cl.m_strFileName;
  }

	unsigned long server_ip = inet_addr(ipaddr);
	if (server_ip == INADDR_NONE)
	{
		fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", ipaddr);
		exit(1);
	}

#if defined(WINDOWS)
	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
		exit(2);
	}
#endif


	SOCKET sd;
	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sd == INVALID_SOCKET)
	{
		fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
		exit(2);
	}

#if defined(WINDOWS)
	unsigned long enable_nonblocking = 1;
	if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
	{
		fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
		exit(1);
	}
#else
    if (-1 == fcntl(sd, F_SETFL, O_NONBLOCK))
    {
        perror("Kann Socket nicht auf non-blocking setzen");
        exit(1);
    }
#endif

	sockaddr_in sa;
	memset(&sa, 0, sizeof sa);
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port = 0;

	if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
	{
		fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
		exit(2);
	}

  if (m_player == NULL) {
    m_player = new Player(sd, server_ip, version);
    //VERIFY(SetTimer(2, 10, NULL) != 0);
    AfxBeginThread(FrameThread,(LPVOID)m_player);  //worker Thread starten
  }

  while (true) {
    Sleep(20000); // and wait for the workerthread to terminate
  }
}


int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// MFC initialisieren, Ausgabe und Fehlermeldung bei Fehlern
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// ZU ERLEDIGEN: Fehlercode gem Ihren Anforderungen ndern
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		// ZU ERLEDIGEN: Anwendungsverhalten hier festlegen.
		CString strHello;
		strHello.LoadString(IDS_HELLO);
		cout << (const TCHAR*)strHello << endl;
    initialize();
	}

	return nRetCode;
}




