// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#ifndef GAMESTATUS_H
#define GAMESTATUS_H

#include "FlyingObject.h"
#include "Asteroid.h"
#include "Saucer.h"
#include "Ship.h"
#include "Shot.h"
#include "KeysPacket.h"

static const int MAX_ASTEROIDS = 28; // soll nicht mehr als 26 geben
static const int MAX_SHOTS     = 8; // soll nicht mehr als 4 eigene + 2 vom ufo geben

#define UNKNOWN    0
#define PREPARE    1
#define INLEVEL    2
#define LEVELDONE  3

class GameStatus
{
public:
	int mode;
	int level;           // Level des Spiels
	KeysPacket sentKeys; // am Ende dieses gameFrames gesendetes Keypaket
	int shipCount;       // Anzahl der Raumschiffe
	int score;           // Punkteanzahl
	bool isThrustEnabled(void);
	int jmpl;             // Nach E2-Frame ist thrust erfolgreich, sonst nicht
	void setShip(int x, int y,int bx,int by);
	void setSaucer(int x, int y, int size);
  void addAsteroid(int x, int y, int type, int sf);
	int findAsteroid(int x, int y, int type, int sf,int frames);
	int findShot(int x, int y, int frames);
	unsigned char readping;  // gelesener keyping
  bool ship_present;
	int nships;         // 1 = Schiff sichtbar
  bool saucer_present;
	int nsaucers;       // 1 = UFO sichtbar
  Ship   ship;
  Saucer saucer;
	int nasteroidsK;     // Anzahl Asteroiden Klein
	int nasteroidsM;     // Anzahl Asteroiden Mittel
	int nasteroidsG;     // Anzahl Asteroiden Gro
	int nasteroids;     // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;         // Anzahl Schsse
	Shot shots[MAX_SHOTS];

  int sumLostPackets; // Summe verlorener Frames
  int nowLostPackets; // vor diesem Frame verlorene Frames
  int nFrames;        // FrameNummer aufsummiert
  int nLevelFrames;   // FrameNummer aufsummiert je Level
  unsigned char frameno; // Framenummer aus dem Packet
  void copy(GameStatus *old);
	void clear(void);
  char message[20];  // MAME Erweiterung fr Online Spiel
  GameStatus();
};


#endif
