// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
// changed by Reno Granzow

#include <math.h>

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;
static const int XACHSE = 0;
static const int YACHSE = 1;

static const char LEFT = 1;
static const char RIGHT = 2;
static const char NOROT = 0;

#define SP_LIMIT 0.707107 /* 1/(sqrt(2) */


class Asteroid
{
public:
	int x;			// Koordinaten des Mittelpunkts
	int y;
	int xl;			// Koordinaten des mittels mittlerer Latenz errechneten Mittelpunkts
	int yl;
	bool yl_avail;		// Flag fr Verfgbarkeit des approximierten Mittelpunkts
	int num_shots;		// Anzahl Schssen auf diesen Asteroiden
	int timeout;		// kein weitere Schuss, solange timeout > 0

	int frame_count_a;	// fr Geschwindigkeitmessung
	int initial_asteroid_x;
	int initial_asteroid_y;
	int current_asteroid_dist_x;
	int current_asteroid_dist_y;
	float current_asteroid_speed_x;
	float current_asteroid_speed_y;
	int prev_asteroid_x;
	int prev_asteroid_y;
	float kreuzprodukt;		// Kreuzprodukt Ausrichtung Schiff und Vektor Schiff/Asteroid
	unsigned char dx_dy_index; 	// Ausrichtung Schiff bei Schuss
	int look_for_shot;		// Zeitpunkt Schuss abgefeuert
	bool bad;
	float tp;			// approx. Anzahl Frames bis Asteroid vom Schuss getroffen
	float vp;			// Skalarprodukt Ausrichtung Schiff und Vektor Schiff/Asteroid

	int dist; // Abstand Schiff/Asteroid (^2)
	float w;
	int dx;   // Vektor Schiff / Asteroid
	int dy;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf, int latenz, int found);
	inline float kreuznorm(float x, float y, float u, float v);
	void find(float x, float y, float& xneu, float& yneu);
//	bool DistToFutureShipPosition(float Sx, float Sy, float Ax, float Ay, float prev_Ax, float prev_Ay, float speed_x, float speed_y, int& x, int& y);
	void compute_kreuzprodukt(int ship_x, int ship_y, float ship_dir_x, float ship_dir_y, float foo);
	void print_asteroid(int id=0);
	bool approx_collision(int ship_x, int ship_y);
	float approx_mp(int dx, int dy, float ship_dir_x, float ship_dir_y, int dist);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nasteroids_new; // Anzahl Asteroiden
	Asteroid asteroids_new[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	GameStatus();
	void clear(void);
	int findMatchingAsteroid(int start_index, int x, int y, int type, int sf);
};




#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};

class NamePacket
{
private:
	char signature[38];
public:

	NamePacket(void);
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
	void SendPacket(NamePacket &packet);
	inline float kreuznorm(float x, float y, float u, float v);
	int sync(int dx, int dy, int t, char latenz, char frame_error, unsigned char &index);
	void find(float x, float y, float& xneu, float& yneu);
	void CopyAsteroids(GameStatus& game);
private:
	SOCKET sd;
	ADDRESS server_ip;
};


inline float Player::kreuznorm(float x, float y, float u, float v)
{
	float l2= sqrt(u*u + v*v);
    float sp = (x*v + y*u)/(l2 * SP_LIMIT); 
    if( sp > SP_LIMIT ) 
    { 
        float uu; 
        float vv; 
        find(v/l2,u/l2,vv,uu); 
        return ((x*uu - y*vv)); 
    } 
    else 
    { 
        return ((x*u - y*v)/(l2)); 
    } 
}



class rot_queue 
{ 
        unsigned long queue; 
public: 
        inline void push(int rot_dir); 
        inline int pop(); 
        inline int top(); 
        inline void empty(); 
        inline int get(int index); 
        inline int sum(int index); 

}; 

inline void rot_queue::push(int rot_dir) 
{ 
        queue<<=2; 
        ((rot_dir==-1) ? (queue|=RIGHT) : ( (rot_dir==1) ? (queue|=LEFT) : (queue|=NOROT) )); 
} 

inline void rot_queue::empty() 
{ 
        queue=0; 
} 

inline int rot_queue::top() 
{ 
        return( ((queue&3) == RIGHT) ? -1 : ( ((queue&3) == LEFT) ? 1 : 0 ) ); 
}

inline int rot_queue::get(int index)
{
		unsigned long tmp; 
		tmp = 3;

		tmp <<= (index*2);
		tmp &= queue;
		tmp >>= (index*2);
		return( ((tmp&3) == RIGHT) ? -1 : ( ((tmp&3) == LEFT) ? 1 : 0 ) );
}

inline int rot_queue::sum(int index)
{
		unsigned long tmp; 
		int ret = 0;
		tmp = queue;

		for(int i = 0; i<index; i++)
		{
			ret += ( ((tmp&3) == RIGHT) ? -1 : ( ((tmp&3) == LEFT) ? 1 : 0 ) );
			tmp >>=2;
		}
		return ret;
}

inline float Asteroid::kreuznorm(float x, float y, float u, float v)
{
	float l2= sqrt(u*u + v*v);
    float sp = (x*v + y*u)/(l2 * SP_LIMIT); 
    if( sp > SP_LIMIT ) 
    { 
        float uu; 
        float vv; 

		find(v/l2,u/l2,vv,uu); 
        return ((x*uu - y*vv)); 
    } 
    else 
    { 
        return ((x*u - y*v)/(l2)); 
    } 

}
