﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ct.Asteroid
{
    public class collision
    {
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        int dx1 = 0;
        int dx2 = 0;
        int dy1 = 0;
        int dy2 = 0;
        int radius1 = 0;
        int radius2 = 0;
        DateTime motion_start1 = DateTime.Now;
        DateTime motion_start2 = DateTime.Now;
        public int collision_x = 0;
        public int collision_y = 0;
        public int collision_time = 60000;

        public void Clear()
        {
            x1 = 0;
            x2 = 0;
            y1 = 0;
            y2 = 0;
            dx1 = 0;
            dx2 = 0;
            dy1 = 0;
            dy2 = 0;
            radius1 = 0;
            radius2 = 0;
            motion_start1 = DateTime.Now;
            motion_start2 = DateTime.Now;
        }

        public void SetAsteroid1(int NrOfAsteroid, GameStatus game)
        {
            x1 = game.asteroids[NrOfAsteroid].x;
            y1 = game.asteroids[NrOfAsteroid].y;
            dx1 = game.asteroids[NrOfAsteroid].dx;
            dy1 = game.asteroids[NrOfAsteroid].dy;
            motion_start1 = game.asteroids[NrOfAsteroid].motion_start;
            radius1 = game.asteroids[NrOfAsteroid].radius;
        }
        public void SetAsteroid2(int NrOfAsteroid, GameStatus game)
        {
            x2 = game.asteroids[NrOfAsteroid].x;
            y2 = game.asteroids[NrOfAsteroid].y;
            dx2 = game.asteroids[NrOfAsteroid].dx;
            dy2 = game.asteroids[NrOfAsteroid].dy;
            motion_start2 = game.asteroids[NrOfAsteroid].motion_start;
            radius2 = game.asteroids[NrOfAsteroid].radius;
        }
        public void SetShot1(int NrOfShot, GameStatus game)
        {
            x1 = game.shots[NrOfShot].x;
            y1 = game.shots[NrOfShot].y;
            dx1 = game.shots[NrOfShot].dx;
            dy1 = game.shots[NrOfShot].dy;
            motion_start1 = game.shots[NrOfShot].motion_start;
            radius1 = game.shots[NrOfShot].radius;
        }
        public void SetShip2(GameStatus game)
        {
            x2 = game.ship.x;
            y2 = game.ship.y;
            dx2 = game.ship.move_dx;
            dy2 = game.ship.move_dy;
            motion_start2 = game.ship.motion_start;
            radius2 = game.ship.radius + 3;           

        }
        public void SetSaucer2(GameStatus game)
        {
            x2 = game.saucer.x;
            y2 = game.saucer.y;
            dx2 = game.saucer.dx;
            dy2 = game.saucer.dy;
            motion_start2 = game.saucer.motion_start;
            radius2 = game.saucer.radius;

        }
        public bool DetectCollision(int number_of_steps, int steptime)
        {
            //Berechnungszeit für Vektor1 in ms
            int time1 = (DateTime.Now - motion_start1).Seconds * 1000 + ((DateTime.Now - motion_start1).Milliseconds);
            //Berechnungszeit für Vektor2 in ms
            int time2 = (DateTime.Now - motion_start2).Seconds * 1000 + ((DateTime.Now - motion_start2).Milliseconds);

            //if ((time1 < 20) || (time2 < 20))
            //{
            //    collision_time = number_of_steps * steptime;
            //    return false;
            //}

            float einzelschritt_x1 = (float)dx1 / ((float)time1 / (float)steptime);
            float einzelschritt_y1 = (float)dy1 / ((float)time1 / (float)steptime); ;
            float einzelschritt_x2 = (float)dx2 / ((float)time2 / (float)steptime); ;
            float einzelschritt_y2 = (float)dy2 / ((float)time2 / (float)steptime); ;


            for (int i = 0; i < number_of_steps; i++)
            {
                int target_x1 = x1 + (int)((float)i * einzelschritt_x1);
                ClipAbsolute(ref target_x1, 0, 1023);
                int target_y1 = y1 + (int)((float)i * einzelschritt_y1);
                ClipAbsolute(ref target_y1, 127, 895);
                int target_x2 = x2 + (int)((float)i * einzelschritt_x2);
                ClipAbsolute(ref target_x2, 0, 1023);
                int target_y2 = y2 + (int)((float)i * einzelschritt_y2);
                ClipAbsolute(ref target_y2, 127, 895);
                //dann Abstand berechnen, auch mit Clipping
                int dist_x = target_x1 - target_x2;
                while (dist_x < -512) dist_x += 1024;
                while (dist_x > 511) dist_x -= 1024;
                int dist_y = target_y1 - target_y2;
                while (dist_y < -384) dist_y += 768;
                while (dist_y > 383) dist_y -= 768;
                int dist = (int)Math.Sqrt(dist_x * dist_x + dist_y * dist_y);
                if (dist < (radius1 + radius2)) //wenn eine Kollision auftritt
                {
                    collision_x = x1;
                    collision_y = y1;
                    collision_time = i * steptime;
                    return true;
                }
            }
            collision_time = number_of_steps * steptime;    //wird erst nach Ablauf der Simulation kollidieren
            return false;
        }

        int ClipAbsolute(ref int value, int ClipToMin, int ClipToMax)
        {
            if (value > ClipToMax)
                value -= (ClipToMax - ClipToMin);
            if (value < ClipToMin)
                value += (ClipToMax - ClipToMin);
            return value;
        }
    }
 
}
