﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System;

namespace stefc.asteroids.strategy
{
    /// <summary>
    /// Liefert einen Ringbuffer mit verschiedenen Strategien 
    /// </summary>
    static class StrategyFactory
    {
        /// <summary>
        /// Strategie erzeugen
        /// </summary>
        /// <param name="controller"></param>
        /// <returns></returns>
        public static AbstractStrategy Create(IController controller)
        {
            AbstractStrategy startStrategy = // new WinkelByteStrategy(controller);
                new StartStrategy(controller);

            
            AbstractStrategy endStrategy = new EndStrategy(controller);

            startStrategy.Next = endStrategy;
            endStrategy.Next = startStrategy;

            return startStrategy; 
        }
    }
}
