﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System.Collections.Generic;
using System.Linq;
using System;

namespace stefc.asteroids
{
    /// <summary>
    /// Helper Methods for the Game
    /// </summary>
    public class GameUtils
    {
        private static Point[] fireAngles = new Point[256];
        private static double[] angles = new double[256];
        private static SortedList<double, int> sortedAngles; 

        static GameUtils()
        {
            fireAngles[0] = new Point(1536, 0);
            fireAngles[1] = new Point(1536, 0);
            fireAngles[2] = new Point(1528, 152);
            fireAngles[3] = new Point(1504, 296);
            fireAngles[4] = new Point(1472, 440);
            fireAngles[5] = new Point(1472, 440);
            fireAngles[6] = new Point(1416, 584);
            fireAngles[7] = new Point(1360, 720);
            fireAngles[8] = new Point(1280, 856);
            fireAngles[9] = new Point(1280, 856);
            fireAngles[10] = new Point(1192, 976);
            fireAngles[11] = new Point(1088, 1088);
            fireAngles[12] = new Point(976, 1192);
            fireAngles[13] = new Point(976, 1192);
            fireAngles[14] = new Point(856, 1280);
            fireAngles[15] = new Point(720, 1360);
            fireAngles[16] = new Point(584, 1416);
            fireAngles[17] = new Point(584, 1416);
            fireAngles[18] = new Point(440, 1472);
            fireAngles[19] = new Point(296, 1504);
            fireAngles[20] = new Point(152, 1528);
            fireAngles[21] = new Point(152, 1528);
            fireAngles[22] = new Point(-152, 1528);
            fireAngles[23] = new Point(-296, 1504);
            fireAngles[24] = new Point(-296, 1504);
            fireAngles[25] = new Point(-440, 1472);
            fireAngles[26] = new Point(-584, 1416);
            fireAngles[27] = new Point(-720, 1360);
            fireAngles[28] = new Point(-720, 1360);
            fireAngles[29] = new Point(-856, 1280);
            fireAngles[30] = new Point(-976, 1192);
            fireAngles[31] = new Point(-1088, 1088);
            fireAngles[32] = new Point(-1088, 1088);
            fireAngles[33] = new Point(-1192, 976);
            fireAngles[34] = new Point(-1280, 856);
            fireAngles[35] = new Point(-1360, 720);
            fireAngles[36] = new Point(-1360, 720);
            fireAngles[37] = new Point(-1416, 584);
            fireAngles[38] = new Point(-1472, 440);
            fireAngles[39] = new Point(-1504, 296);
            fireAngles[40] = new Point(-1504, 296);
            fireAngles[41] = new Point(-1528, 152);
            fireAngles[42] = new Point(-1536, 0);
            fireAngles[43] = new Point(-1536, 0);
            fireAngles[44] = new Point(-1528, -152);
            fireAngles[45] = new Point(-1528, -152);
            fireAngles[46] = new Point(-1504, -296);
            fireAngles[47] = new Point(-1472, -440);
            fireAngles[48] = new Point(-1416, -584);
            fireAngles[49] = new Point(-1416, -584);
            fireAngles[50] = new Point(-1360, -720);
            fireAngles[51] = new Point(-1280, -856);
            fireAngles[52] = new Point(-1192, -976);
            fireAngles[53] = new Point(-1192, -976);
            fireAngles[54] = new Point(-1088, -1088);
            fireAngles[55] = new Point(-976, -1192);
            fireAngles[56] = new Point(-856, -1280);
            fireAngles[57] = new Point(-856, -1280);
            fireAngles[58] = new Point(-720, -1360);
            fireAngles[59] = new Point(-584, -1416);
            fireAngles[60] = new Point(-440, -1472);
            fireAngles[61] = new Point(-440, -1472);
            fireAngles[62] = new Point(-296, -1504);
            fireAngles[63] = new Point(-152, -1528);
            fireAngles[64] = new Point(0, -1536);
            fireAngles[65] = new Point(152, -1528);
            fireAngles[66] = new Point(296, -1504);
            fireAngles[67] = new Point(440, -1472);
            fireAngles[68] = new Point(440, -1472);
            fireAngles[69] = new Point(584, -1416);
            fireAngles[70] = new Point(720, -1360);
            fireAngles[71] = new Point(856, -1280);
            fireAngles[72] = new Point(856, -1280);
            fireAngles[73] = new Point(976, -1192);
            fireAngles[74] = new Point(1088, -1088);
            fireAngles[75] = new Point(1192, -976);
            fireAngles[76] = new Point(1192, -976);
            fireAngles[77] = new Point(1280, -856);
            fireAngles[78] = new Point(1360, -720);
            fireAngles[79] = new Point(1416, -584);
            fireAngles[80] = new Point(1416, -584);
            fireAngles[81] = new Point(1472, -440);
            fireAngles[82] = new Point(1504, -296);
            fireAngles[83] = new Point(1528, -152);
            fireAngles[84] = new Point(1528, -152);
            fireAngles[85] = new Point(1536, 0);
            fireAngles[86] = new Point(1536, 0);
            fireAngles[87] = new Point(1528, 152);
            fireAngles[88] = new Point(1504, 296);
            fireAngles[89] = new Point(1504, 296);
            fireAngles[90] = new Point(1472, 440);
            fireAngles[91] = new Point(1416, 584);
            fireAngles[92] = new Point(1360, 720);
            fireAngles[93] = new Point(1360, 720);
            fireAngles[94] = new Point(1280, 856);
            fireAngles[95] = new Point(1192, 976);
            fireAngles[96] = new Point(1088, 1088);
            fireAngles[97] = new Point(1088, 1088);
            fireAngles[98] = new Point(976, 1192);
            fireAngles[99] = new Point(856, 1280);
            fireAngles[100] = new Point(720, 1360);
            fireAngles[101] = new Point(720, 1360);
            fireAngles[102] = new Point(584, 1416);
            fireAngles[103] = new Point(440, 1472);
            fireAngles[104] = new Point(296, 1504);
            fireAngles[105] = new Point(296, 1504);
            fireAngles[106] = new Point(152, 1528);
            fireAngles[107] = new Point(-152, 1528);
            fireAngles[108] = new Point(-152, 1528);
            fireAngles[109] = new Point(-296, 1504);
            fireAngles[110] = new Point(-440, 1472);
            fireAngles[111] = new Point(-584, 1416);
            fireAngles[112] = new Point(-584, 1416);
            fireAngles[113] = new Point(-720, 1360);
            fireAngles[114] = new Point(-856, 1280);
            fireAngles[115] = new Point(-976, 1192);
            fireAngles[116] = new Point(-976, 1192);
            fireAngles[117] = new Point(-1088, 1088);
            fireAngles[118] = new Point(-1192, 976);
            fireAngles[119] = new Point(-1280, 856);
            fireAngles[120] = new Point(-1280, 856);
            fireAngles[121] = new Point(-1360, 720);
            fireAngles[122] = new Point(-1416, 584);
            fireAngles[123] = new Point(-1472, 440);
            fireAngles[124] = new Point(-1472, 440);
            fireAngles[125] = new Point(-1504, 296);
            fireAngles[126] = new Point(-1528, 152);
            fireAngles[127] = new Point(-1536, 0);
            fireAngles[128] = new Point(-1536, 0);
            fireAngles[129] = new Point(-1536, 0);
            fireAngles[130] = new Point(-1528, -152);
            fireAngles[131] = new Point(-1504, -296);
            fireAngles[132] = new Point(-1472, -440);
            fireAngles[133] = new Point(-1472, -440);
            fireAngles[134] = new Point(-1416, -584);
            fireAngles[135] = new Point(-1360, -720);
            fireAngles[136] = new Point(-1280, -856);
            fireAngles[137] = new Point(-1280, -856);
            fireAngles[138] = new Point(-1192, -976);
            fireAngles[139] = new Point(-1088, -1088);
            fireAngles[140] = new Point(-976, -1192);
            fireAngles[141] = new Point(-976, -1192);
            fireAngles[142] = new Point(-856, -1280);
            fireAngles[143] = new Point(-720, -1360);
            fireAngles[144] = new Point(-584, -1416);
            fireAngles[145] = new Point(-584, -1416);
            fireAngles[146] = new Point(-440, -1472);
            fireAngles[147] = new Point(-296, -1504);
            fireAngles[148] = new Point(-152, -1528);
            fireAngles[149] = new Point(-152, -1528);
            fireAngles[150] = new Point(152, -1528);
            fireAngles[151] = new Point(296, -1504);
            fireAngles[152] = new Point(296, -1504);
            fireAngles[153] = new Point(440, -1472);
            fireAngles[154] = new Point(584, -1416);
            fireAngles[155] = new Point(720, -1360);
            fireAngles[156] = new Point(720, -1360);
            fireAngles[157] = new Point(856, -1280);
            fireAngles[158] = new Point(976, -1192);
            fireAngles[159] = new Point(1088, -1088);
            fireAngles[160] = new Point(1088, -1088);
            fireAngles[161] = new Point(1192, -976);
            fireAngles[162] = new Point(1280, -856);
            fireAngles[163] = new Point(1360, -720);
            fireAngles[164] = new Point(1360, -720);
            fireAngles[165] = new Point(1416, -584);
            fireAngles[166] = new Point(1472, -440);
            fireAngles[167] = new Point(1504, -296);
            fireAngles[168] = new Point(1504, -296);
            fireAngles[169] = new Point(1528, -152);
            fireAngles[170] = new Point(1536, 0);
            fireAngles[171] = new Point(1536, 0);
            fireAngles[172] = new Point(1528, 152);
            fireAngles[173] = new Point(1528, 152);
            fireAngles[174] = new Point(1504, 296);
            fireAngles[175] = new Point(1472, 440);
            fireAngles[176] = new Point(1416, 584);
            fireAngles[177] = new Point(1416, 584);
            fireAngles[178] = new Point(1360, 720);
            fireAngles[179] = new Point(1280, 856);
            fireAngles[180] = new Point(1192, 976);
            fireAngles[181] = new Point(1192, 976);
            fireAngles[182] = new Point(1088, 1088);
            fireAngles[183] = new Point(976, 1192);
            fireAngles[184] = new Point(856, 1280);
            fireAngles[185] = new Point(856, 1280);
            fireAngles[186] = new Point(720, 1360);
            fireAngles[187] = new Point(584, 1416);
            fireAngles[188] = new Point(440, 1472);
            fireAngles[189] = new Point(440, 1472);
            fireAngles[190] = new Point(296, 1504);
            fireAngles[191] = new Point(152, 1528);
            fireAngles[192] = new Point(0, 1536);
            fireAngles[193] = new Point(-152, 1528);
            fireAngles[194] = new Point(-296, 1504);
            fireAngles[195] = new Point(-440, 1472);
            fireAngles[196] = new Point(-440, 1472);
            fireAngles[197] = new Point(-584, 1416);
            fireAngles[198] = new Point(-720, 1360);
            fireAngles[199] = new Point(-856, 1280);
            fireAngles[200] = new Point(-856, 1280);
            fireAngles[201] = new Point(-976, 1192);
            fireAngles[202] = new Point(-1088, 1088);
            fireAngles[203] = new Point(-1192, 976);
            fireAngles[204] = new Point(-1192, 976);
            fireAngles[205] = new Point(-1280, 856);
            fireAngles[206] = new Point(-1360, 720);
            fireAngles[207] = new Point(-1416, 584);
            fireAngles[208] = new Point(-1416, 584);
            fireAngles[209] = new Point(-1472, 440);
            fireAngles[210] = new Point(-1504, 296);
            fireAngles[211] = new Point(-1528, 152);
            fireAngles[212] = new Point(-1528, 152);
            fireAngles[213] = new Point(-1536, 0);
            fireAngles[214] = new Point(-1536, 0);
            fireAngles[215] = new Point(-1528, -152);
            fireAngles[216] = new Point(-1504, -296);
            fireAngles[217] = new Point(-1504, -296);
            fireAngles[218] = new Point(-1472, -440);
            fireAngles[219] = new Point(-1416, -584);
            fireAngles[220] = new Point(-1360, -720);
            fireAngles[221] = new Point(-1360, -720);
            fireAngles[222] = new Point(-1280, -856);
            fireAngles[223] = new Point(-1192, -976);
            fireAngles[224] = new Point(-1088, -1088);
            fireAngles[225] = new Point(-1088, -1088);
            fireAngles[226] = new Point(-976, -1192);
            fireAngles[227] = new Point(-856, -1280);
            fireAngles[228] = new Point(-720, -1360);
            fireAngles[229] = new Point(-720, -1360);
            fireAngles[230] = new Point(-584, -1416);
            fireAngles[231] = new Point(-440, -1472);
            fireAngles[232] = new Point(-296, -1504);
            fireAngles[233] = new Point(-296, -1504);
            fireAngles[234] = new Point(-152, -1528);
            fireAngles[235] = new Point(152, -1528);
            fireAngles[236] = new Point(152, -1528);
            fireAngles[237] = new Point(296, -1504);
            fireAngles[238] = new Point(440, -1472);
            fireAngles[239] = new Point(584, -1416);
            fireAngles[240] = new Point(584, -1416);
            fireAngles[241] = new Point(720, -1360);
            fireAngles[242] = new Point(856, -1280);
            fireAngles[243] = new Point(976, -1192);
            fireAngles[244] = new Point(976, -1192);
            fireAngles[245] = new Point(1088, -1088);
            fireAngles[246] = new Point(1192, -976);
            fireAngles[247] = new Point(1280, -856);
            fireAngles[248] = new Point(1280, -856);
            fireAngles[249] = new Point(1360, -720);
            fireAngles[250] = new Point(1416, -584);
            fireAngles[251] = new Point(1472, -440);
            fireAngles[252] = new Point(1472, -440);
            fireAngles[253] = new Point(1504, -296);
            fireAngles[254] = new Point(1528, -152);
            fireAngles[255] = new Point(1536, 0);

            sortedAngles = new SortedList<double, int>();

            double step = (360 * 3) / 256.0;
            for (int i = 0; i < 256; i++)
            {
                double angle = MathUtils.NormalizeAngle(i * step);
                angles[i] = angle;
                sortedAngles.Add(angle, i);
            }
        }

        /// <summary>
        /// Sucht den nächsten Asteroiden in einer Liste ohne Berücksichtigung 
        /// der Bewegung
        /// </summary>
        /// <param name="asteroids"></param>
        /// <returns></returns>
        public static Vector SearchNearestAsteroid(IList<Asteroid> asteroids)
        {
            Vector result = null;

            foreach (Asteroid asteroid in asteroids)
            {
                Vector a = Vector.CreateCartesian(asteroid.X, asteroid.Y);
                if (result == null || result.Length > a.Length)
                    result = a;
            }
            return result;
        }

        public static double ByteToAngle(int index)
        {
            return angles[index];
        }

        private static Point GetFireAngle(int index)
        {
            return fireAngles[index];
        }

        public static int AngleSync(Point[] points)
        {
            int len=points.Length;
            for (int i = 0; i < 256; i++)
            {
                int j = 0;
                bool equal = true;
                while (j < len && equal)
                {
                    equal = fireAngles[(i+j) % 256].Equals(points[j]);
                    j++;
                }

                if (equal)
                   return (i+len-1) % 256;
            }
            return -1;
        }

        /// <summary>
        /// Ist das WinkelByte out of Sync ? 
        /// </summary>
        /// <param name="winkelByte"></param>
        /// <param name="v"></param>
        /// <returns></returns>
        public static bool IsOutOfSync(int winkelByte, Point v)
        {
            if (winkelByte == -1)
                return true;

            Point p = GetFireAngle(winkelByte);
            //if (!p.Equals(v))
            //    Console.WriteLine("isoutofsync:{0}-{1}", p, v);

            return !p.Equals(v);
        }

        public static int Resync(int winkelByte, Point pt)
        {
            for (int index = 1; index < 3; index++)
            {
                if (fireAngles[(winkelByte + index) % 256].Equals(pt))
                    return (winkelByte + index) % 256;
                if (fireAngles[(winkelByte - index + 256) % 256].Equals(pt))
                    return (winkelByte - index + 256) % 256;
            }
            return -1;
        }

        public static int AngleByteDelta(int a, int b)
        {
            int c = Math.Abs(a - b);
            return Math.Min(c, Math.Abs(c-256));
        }

        public static int[] GetBestAngle(Vector target, SpaceObject spaceObject)
        {

            //double hitAngle = Math.Abs(MathUtils.GetHitAngle(target, radius));
            //if (radius != -1)
            //    return (from kvp in sortedAngles orderby GetDelta(target,kvp.Key)
            //                        where ((target.Length < Const.SHOT_DISTANCE) &&
            //                        (GetDelta(target,kvp.Key) < hitAngle))
            //                        select 
            //                            kvp.Value).Take(3).ToArray();
            //else
               return (from kvp in sortedAngles
                       where IsHitTest(target, kvp.Value, spaceObject)
                        orderby GetDelta(target, kvp.Key)
                        select
                            kvp.Value).Take(3).ToArray();
        }
         
        private static int GetDelta(Vector target, double key)
        {
            return (int)Math.Abs(MathUtils.AngleDelta(
                        MathUtils.NormalizeAngle(target.Angle),
                        MathUtils.NormalizeAngle(key)));
        }

        public static int GetNearestAngle(int source, int[] destinations)
        {
            int result = -1;
            int minDelta = 256;
            foreach (int dest in destinations)
            {
                int delta = AngleByteDelta(source, dest);
                if (delta<minDelta)
                {    
                    result=dest;
                    minDelta=delta;
                }
            }
            return result;
        }

        public static bool IsDangerous(SpaceObject spaceObject, Ship ship)
        {
            Vector a = spaceObject.NextPosition;
            Vector b = spaceObject.Velocity;

            double angle = MathUtils.GetHitAngle(a, ship.GetRadius(), spaceObject.GetRadius());

            double aAngle = MathUtils.NormalizeAngle(a.Angle);
            double bAngle = MathUtils.NormalizeAngle(b.Angle - 180);

            double delta = MathUtils.AngleDelta(bAngle, aAngle);

            if (Math.Abs(delta) <= angle)
                if (b.Length > 0)
                    return true;

            return false;
        }

        public static Vector GetTarget(SpaceObject spaceObject)
        {
            double dx = spaceObject.X +spaceObject.Dx;
            double dy = spaceObject.Y +spaceObject.Dy;
            
            Vector a = Vector.CreateCartesian(dx,dy);
            Vector b = Vector.CreateCartesian(spaceObject.Dx, spaceObject.Dy);
            double speed = 8.0 / b.Length;

            Vector target = MathUtils.GetDeltaAngle(a, b, speed);
            if (target == null)
                return null;

            dx = target.X;
            while (dx < -(Const.WIDTH / 2)) dx += Const.WIDTH; // dx normalisieren auf -512 ... 511
            while (dx >= (Const.WIDTH / 2)) dx -= Const.WIDTH;

            dy = target.Y;
            while (dy < -(Const.HEIGHT / 2)) dy += Const.HEIGHT;  // dy normalisieren auf -384 ... 383
            while (dy >= (Const.HEIGHT / 2)) dy -= Const.HEIGHT;

            return Vector.CreateCartesian(dx, dy);
        }

        public static bool IsHitTest(Vector target, int dest, SpaceObject spaceObject)
        {
            double destAngle = MathUtils.NormalizeAngle(ByteToAngle(dest));
            double srcAngle = MathUtils.NormalizeAngle(target.Angle);
            double radius = spaceObject.GetRadius()/1.0;

            double angle = MathUtils.GetHitAngle(target, radius);

            double delta = MathUtils.AngleDelta(srcAngle, destAngle);

            return Math.Abs(delta) <= angle;
        }
                        
    }
}
