/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.game.state;

import java.util.List;

import de.hfaber.asteroids.game.field.Point;
import de.hfaber.asteroids.game.field.Screen;
import de.hfaber.asteroids.game.objects.GameObject;

/**
 * A match strategy that matches an object from the current game status
 * with an object from a previous game status, if the object from the
 * current game status is <em>exactly</em> at the position that was projected
 * from the object of the previous game status. 
 * 
 * @author Henning Faber
 */
class ExactMatchStrategy implements IMatchStrategy {

    /* (non-Javadoc)
     * @see de.hfaber.asteroids.asteroids.game.state.IMatchStrategy#satisfiesPrecondition(de.hfaber.asteroids.asteroids.game.objects.GameObject, de.hfaber.asteroids.asteroids.game.objects.GameObject, int)
     */
    public boolean satisfiesPrecondition(GameObject current, GameObject prev,
            int frameGap) {
        Point projection = prev.project(frameGap);
        Point delta = projection.delta(current.getLocation());
        return (Math.abs(delta.getX()) < Screen.INTERNAL_PRECISION)
                && (Math.abs(delta.getY()) < Screen.INTERNAL_PRECISION);
    }

    /* (non-Javadoc)
     * @see de.hfaber.asteroids.asteroids.game.state.IMatchStrategy#selectBestMatch(java.util.List, de.hfaber.asteroids.asteroids.game.objects.GameObject, int)
     */
    public GameObject selectBestMatch(GameObject current, 
            List<? extends GameObject> matchList, int frameGap) {
        // this strategy does not allow a list of possible matches
        return null;
    }

}
