/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.client;

import java.util.EventObject;

import de.hfaber.asteroids.game.state.GameStatus;

/**
 * An event that indicates that a new game status has been received.
 * 
 * @author Henning Faber
 */
public class GameStatusEvent extends EventObject {
    
    /**
     * Serial version uid for serialization API.
     */
    private static final long serialVersionUID = -6340731964100294110L;

    /**
     * the game status that is distributed with this event
     */
    private final GameStatus m_gameStatus;
    
    /**
     * Creates a game status event for the given source and game status.
     * 
     * @param source the source
     * @param gameStatus the game status that is distributed with this
     *  event
     */
    public GameStatusEvent(Object source, GameStatus gameStatus) {
        super(source);
        m_gameStatus = gameStatus;
    }

    /**
     * @return the gameStatus
     */
    public final GameStatus getGameStatus() {
        return m_gameStatus;
    }
}
