// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.util.settings.BoundsPreferenceProperty;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 *  A dialog allowing to change certain settings.
 *  
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class SettingsDialog
        extends JDialog
{
  static {
    I18n.addAppResourceBase("de.caff.util.settings.swing.SettingsResourceBundle");
  }
  /** The editor provider. */
  private final EditorProvider editorProvider;
  /** Left with okay? */
  private boolean okay = false;

  /**
   *  Constructor.
   *  @param component component of the window for which this dialog is displayed
   *  @param title     dialog title
   *  @param bpp       preference for bounds
   *  @param editorProvider editor provider
   */
  public SettingsDialog(JComponent     component,
                        String         title,
                        final BoundsPreferenceProperty bpp,
                        EditorProvider editorProvider)
  {
    super(getFrameAncestor(component), title, true);
    this.editorProvider = editorProvider;
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(editorProvider.getEditor(), BorderLayout.CENTER);

    JButton ok     = new RJButton("Ok");
    JButton cancel = new RJButton("Cancel");
    Box buttons = Box.createHorizontalBox();
    buttons.add(Box.createHorizontalGlue());
    buttons.add(ok);
    buttons.add(cancel);
    buttons.add(Box.createHorizontalGlue());
    getContentPane().add(buttons, BorderLayout.SOUTH);

    ok.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        ok(bpp);
      }
    });
    cancel.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        cancel(bpp);
      }
    });
    addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent e)
      {
        cancel(bpp);
      }
    });
    setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
    if (!bpp.setWindowBounds(this)) {
      pack();
      setLocationRelativeTo(component);
    }
  }

  /**
   *  Get a frame ancestor for a given component.
   *  @param comp component
   *  @return frame in which this component is displayed or <code>null</code> if the component is not
   *          displayed in a frame
   */
  private static Frame getFrameAncestor(JComponent comp)
  {
    Window window = SwingUtilities.getWindowAncestor(comp);
    if (window instanceof Frame) {
      return (Frame)window;
    }
    else {
      return null;
    }
  }

  /**
   *  Called when the Ok button is pressed.
   *  @param bpp       preference for bounds
   */
  private void ok(BoundsPreferenceProperty bpp)
  {
    okay = true;
    editorProvider.save();
    dispose(bpp);
  }

  /**
   *  Called when the dialog is canceled.
   *  @param bpp       preference for bounds
   */
  private void cancel(BoundsPreferenceProperty bpp)
  {
    okay = false;
    dispose(bpp);
  }

  /**
   *  Disposes the Dialog and then causes show() to return if it is currently
   *  blocked.
   *  @param bpp       preference for bounds
   */
  public void dispose(BoundsPreferenceProperty bpp)
  {
    bpp.setBounds(this);
    editorProvider.goodBye();

    super.dispose();
  }

  /**
   *  Has the user left the dialog via the cancle button?
   *  @return the answer
   */
  public boolean isUserCancelled()
  {
    return !okay;
  }
}
