// ============================================================================
// File:               $File$
//
// Project:
//
// Purpose:
//
// Author:             Rammi
//
// Copyright Notice:   (c) 1999-2006  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date: 2006-02-01 13:48:49 +0100 (Mi, 01 Feb 2006) $
//
// History:	       $Log$
//=============================================================================

package de.caff.util.debug;

/**
 *  This interface is defined as a collection of constants used for debugging.
 */
public interface DebugConstants {
  /** no debugging mask */
  long NO_DEBUG_MASK  = 0x00000000;
  /** trace messages  */
  int  TRACE          = 0;
  /** trace messages flag */
  long TRACE_FLAG     = 0x00000001L << TRACE;
  /** trace message shortcut */
  char TRACE_CHAR     = 'T';
  /** normal messages */
  int  MESSAGE        = TRACE+1;
  /** normal messages flag */
  long MESSAGE_FLAG   = 0x00000001L << MESSAGE;
  /** standard message shortcut */
  char MESSAGE_CHAR   = 'S';
  /** warning messages */
  int  WARNING        = MESSAGE+1;
  /** warning messages flag */
  long WARNING_FLAG   = 0x00000001L << WARNING;
  /** warning message shortcut */
  char WARNING_CHAR   = 'W';
  /** error messages */
  int  ERROR          = WARNING+1;
  /** error messages flag */
  long ERROR_FLAG     = 0x00000001L << ERROR;
  /** error message shortcut */
  char ERROR_CHAR     = 'E';
  /** fatal error messages */
  int  FATAL          = ERROR+1;
  /** fatal error messages flag */
  long FATAL_FLAG     = 0x00000001L << FATAL;
  /** fatal message shortcut */
  char FATAL_CHAR     = 'F';
  /** logging messages */
  int  LOG            = FATAL+1;
  /** logging messages flag */
  long LOG_FLAG       = 0x00000001L << LOG;
  /** logging message shortcut */
  char LOG_CHAR       = 'L';
  /** assertions */
  int  ASSERT         = LOG+1;
  /** assertions flag */
  long ASSERT_FLAG    = 0x00000001L << ASSERT;
  /** assertions shortcut */
  char ASSERT_CHAR    = 'A';
  /** All debug types. */
  int  NR_DEBUG_TYPES = ASSERT+1;
  /** all messages mask */
  long DEBUG_ALL_MASK = (0x00000001L << NR_DEBUG_TYPES)-1;
}
