package de.wens02;

import java.awt.Point;
import java.util.Vector;

public class VectorObject
{
	/** die vom VektorRAM gelieferten Werte,
	 *  x,y=Position, s=Gre, type die Form, z.B. Asteroiden: { 0x8f3, 0x8ff, 0x90d, 0x91a }
	 */
	protected int			x,y,s,type;
	protected boolean isExplosion = false;
	protected boolean	isAsteroid	= false;

	protected static	final int	MaxNewAsteroid	= 8;
	protected static	Asteroid	oldAsteroid[] = new Asteroid[MaxNewAsteroid];
	protected static	Point			newPoint[]		= new Point[MaxNewAsteroid];
	protected static	Point			tmpPoint			= new Point();

	protected static	String		sLastVectorObjects	= "";
	protected static	String		sSeenVectorObjects	= "";

	static {
		for ( int i = 0; i < MaxNewAsteroid; i++ ) {
			newPoint[i] = new Point(0,0);
		}
	}
	
	VectorObject( int x, int y, int s, int type )
	{
		set( x, y, s, type );
	}
	
	protected void set( int x, int y, int s, int type )
	{
		this.x		= x;
		this.y		= y;
		this.s		= s;
		this.type	= type;
	}
	
	protected void setExplosion( int x, int y, int s, int type )
	{
		isExplosion = true;
		isAsteroid	= false;

		set( x, y, s, type );
	}
	
	protected void setAsteroid( int x, int y, int s, int type )
	{
		isAsteroid	= true;
		isExplosion = false;

		set( x, y, s, type );
	}

	protected static void debug(	VectorObject[] vram_objects,
																VectorObject[] vram_objects_new,
																final int new_cnt, boolean force )
	{
		String sLastObjects = "";
		String sSeenObjects = "";

		for ( int i=0; i < vram_objects.length; i++ ) {
			VectorObject obj = vram_objects[i];

			if ( null == obj ) {
				sLastObjects += "|__";
			}
			else if ( obj instanceof Asteroid ) {
				switch ( ((Asteroid)obj).sizeType ) {
					case Asteroid.SIZE_LARGE  : sLastObjects += "|L "; break;
					case Asteroid.SIZE_MEDIUM : sLastObjects += "|M "; break;
					case Asteroid.SIZE_SMALL  : sLastObjects += "|S "; break;
				}
			}
			else if ( obj instanceof Explosion ) {
				sLastObjects += "|ex";
			}
		}
		for ( int i=0; i < new_cnt; i++ ) {
			VectorObject vo = vram_objects_new[i];

			if ( vo.isAsteroid ) {
				switch( vo.s ) {
					case  0 : sSeenObjects += "|L "; break;
					case 15 : sSeenObjects += "|M "; break;
					case 14 : sSeenObjects += "|S "; break;
				}
			}
			if ( vo.isExplosion ) {
				sSeenObjects += "|ex";
			}
		}
		if ( force || !sLastVectorObjects.equals( sLastObjects ) || !sSeenVectorObjects.equals( sSeenObjects ) ) {
			Log.debug( String.format(
					"Frame#%5d: " + sLastObjects + "\n             " +	sSeenObjects,
					AsteroidApp.frame_cnt ) );

			sLastVectorObjects = sLastObjects;
			sSeenVectorObjects = sSeenObjects;
		}
	}
	
	/** max. 27 Asteroiden und Explosionen des aktuellen Vektorram-Inhalts auf
	 *  das vorherige 27-elementige Array abbilden.
	 *  Die freien Slots des alten Arrays mssen erhalten bleiben, um explodierte Asteroiden
	 *  und deren Koordinaten als Ausgangspunkt fr die neuen Asteroiden verwenden zu knnen.
	 *  
	 *  Asteroidentypen: 0x8f3, 0x8ff, 0x90d, 0x91a, Gren: LARGE 0 MEDIUM 15 SMALL 14
	 *  Explosionstypen: XXL 0x880, XL 0x896, L 0x8B5, S 0x8D0
	 *  
	 * @param asteroids
	 * @param vram_objects
	 * @param vram_objects_new
	 * @param new_cnt
	 */
	protected static void sync( Vector<Asteroid> asteroids,
															VectorObject[] vram_objects,
															VectorObject[] vram_objects_new,
															final int new_cnt )
	{
		if ( Debug.sync ) {
			debug( vram_objects, vram_objects_new, new_cnt, false );
		}
		// Spezialfall Levelbeginn: Falls vram_objects keine Objekte enthlt,
		// werden die neuen Elemente 1:1 bernommen:
		boolean empty = true;

		for ( int i=0; empty && i < vram_objects.length; i++ ) {
			if ( null != vram_objects[i] ) {
				empty = false;
			}
		}
		if ( empty ) {
			for ( int i = 0; i < new_cnt; i++ ) {
				VectorObject vo = vram_objects_new[i];

				if ( vo.isAsteroid ) {
					Asteroid a = new Asteroid( vo.x, vo.y, vo.s, vo.type );
					vram_objects[i] = a;
					asteroids.add( a );
				}
			}
			return;
		}
		int new_ast_cnt	= 0;

		for ( int i = 0; i < new_cnt; i++ ) {
			VectorObject vo = vram_objects_new[i];

			if ( vo.isExplosion && Debug.explosions ) {
				Log.debug( String.format(
						"Frame#%5d: Explosion 0x%03x at (%3d,%3d)",
						AsteroidApp.frame_cnt, vo.type, vo.x, vo.y ) );
			}
			if ( vo.isAsteroid && Debug.asteroids ) {
				Log.debug( String.format(
						"Frame#%5d: Asteroid Typ 0x%03x at (%3d,%3d) [vs=%3d]",
						AsteroidApp.frame_cnt, vo.type, vo.x, vo.y ) );
			}
			if ( vo.isExplosion && vo.type == 0x8b5 && vo.s == 11 ) {
				// Erste Explosion eines Asteroiden ist Typ 0x8B5, Gre 11 an der Position des Asteroiden
				for ( int j = 0; j < vram_objects.length; j++ ) {
					VectorObject obj = vram_objects[j];

					if ( null != obj && obj instanceof Asteroid && obj.x == vo.x && obj.y == vo.y ) {
						Asteroid a = (Asteroid)obj;

						if ( Debug.asteroid_explosion ) {
							Log.debug( String.format(
								"Frame#%5d: [%2d] Asteroid Size %2d at [%4d,%4d] explodiert [Exp 0x%03x vs=%2d]",
								AsteroidApp.frame_cnt, j, obj.s, vo.x, vo.y, vo.type, vo.s ) );
						}
						if ( a.sizeType != Asteroid.SIZE_SMALL ) {
							oldAsteroid[ new_ast_cnt++ ] = a;
							oldAsteroid[ new_ast_cnt++ ] = a;
						}
					}
				}
			}
		}
		int new_i = 0;
		int old_i = 0;
		int ast_i	= 0;

		// Neue Objekte verteilen:
		while ( new_i < new_cnt && old_i < vram_objects.length ) {
			VectorObject vo_old	= vram_objects[old_i];
			VectorObject vo_new	= vram_objects_new[new_i];
			
			if ( vo_old instanceof Asteroid ) {
				Asteroid a = (Asteroid)vo_old;

				if ( vo_new.isAsteroid ) {
					// =====================================================
					// ALT: Asteroid, NEU: Asteroid
					// ==> Alter Asteroid bekommt eine neue Position
					// =====================================================
					if ( vo_new.s != a.s || vo_new.type != a.type ) {
						// Wenn sich der Typ im Vektorram ndert, kann dies mit einer Explosion eines
						// mittelgroen und eines seiner Bruchstcke im gleichen Frame zusammenhngen
						Log.error( String.format(
								"Frame#%5d: [%2d,%2d] ALT: 0x%3x,%2d NEU: 0x%3x,%2d",
								AsteroidApp.frame_cnt, old_i, new_i, a.type, a.s, vo_new.type, vo_new.s ) );
						
						debug( vram_objects, vram_objects_new, new_cnt, true );
						
						vram_objects[ old_i++ ] = new Asteroid( vo_new.x, vo_new.y, vo_new.s, vo_new.type );
						new_i++;

						continue;
					}
					tmpPoint.setLocation( vo_new.x, vo_new.y );

					if ( Debug.asteroids && a.getSquaredTorusDistance( tmpPoint, 1 ) > 6.0 ) {
						Log.warn( String.format(
								"Frame#%5d: [%2d] a.frames=%3d, Distanz = %5f",
								AsteroidApp.frame_cnt, old_i, a.frames, a.getSquaredTorusDistance( tmpPoint, 1 ) ) );
					}
					a.update( tmpPoint );

					old_i++;
					new_i++;

					continue;
				}
				// =====================================================
				// ALT: Asteroid, NEU: Explosion
				// ==> Asteroid ist explodiert, Explosion MUSS an der gleichen Stelle wie der Asteroid sein:
				// TODO: Ausnahme: Falls sich ein Asteroid durch Torus-Wrap in einen Schuss hineinbewegt,
				//                 so entspricht die Explosion der Koordinate des Asteroiden in einem Frame spter
				// =====================================================
				if ( vo_new.x != a.x || vo_new.y != a.y ) {
					Log.error( String.format(
							"Frame#%5d: [%2d,%2d] Explosion Typ 0x%03x Size %2d at [%4d,%4d] != Asteroid [%4d,%4d]",
							AsteroidApp.frame_cnt, old_i, new_i, vo_new.type, vo_new.s, vo_new.x, vo_new.y, a.x, a.y ) );
					
					debug( vram_objects, vram_objects_new, new_cnt, true );
					
					new_i++;
					continue;
				}
				a.exploding = true;

				vram_objects[ old_i++ ] = new Explosion( vo_new.x, vo_new.y, vo_new.s, vo_new.type );
				new_i++;
				continue;
			}
			if ( vo_old instanceof Explosion ) {
				if ( vo_new.isExplosion && vo_new.x == vo_old.x && vo_new.y == vo_old.y ) {
					// =====================================================
					// ALT: Explosion, NEU: Explosion an gleicher Stelle
					// ==> Explosion wird weiter animiert
					// =====================================================
					old_i++;
					new_i++;
					continue;
				}
				// alte Explosion ist verpufft, neu synchronisieren
				if ( Debug.explosions ) {
					Log.debug( String.format(
							"Frame#%5d: [%2d] Explosion verpufft",
							AsteroidApp.frame_cnt, old_i ) );
				}
				vram_objects[old_i++] = null;
				continue;
			}
			// =====================================================
			// ALT: leerer Slot
			// NEU: Explosion ==> neu synchronisieren
			//      Asteroid  ==> falls neue Asteroiden enstanden sind, diese abarbeiten
			//                ==> neu synchronisieren sonst
			// =====================================================
			if ( vo_new.isExplosion || ast_i >= new_ast_cnt ) {
				if ( old_i >= vram_objects.length ) {
					debug( vram_objects, vram_objects_new, new_cnt, true );
				}
				while ( ( old_i < vram_objects.length ) && ( null == vram_objects[ old_i ] ) ) {
					old_i++;
				}
				continue;
			}
			// ====================================================================
			// Neuer Asteroid als Zerfallsprodukt eines mittleren oder groen Typs:
			// ====================================================================
			Asteroid a = new Asteroid( vo_new.x, vo_new.y, vo_new.s, vo_new.type );
			
			if ( Debug.asteroid_new ) {
				Asteroid father = oldAsteroid[ast_i];
				
				final int dx = a.x - father.x;
				final int dy = a.y - father.y;
				double alpha = Math.toDegrees( Math.atan2( dx, dy ) );
				double speed = Math.sqrt( dx*dx + dy*dy );

				Log.debug( String.format(
						"Frame#%5d: ID%5d[%4d,%4d,s%2d] dx,dy=%5f,%5f (a=%5f,s=%5f) -> ID%5d[%4d,%4d,s%2d] (alpha=%5f,speed=%5f)",
						AsteroidApp.frame_cnt,
						father.id, father.x, father.y, father.s, father.dx, father.dy, father.getAlpha(), father.getSpeed(),
						a.id, a.x, a.y, a.s, alpha, speed ) );
			}
			vram_objects[ old_i++ ] = a;

			new_i++;
			ast_i++;
		}
		for ( int i = 0; i < old_i; i++ ) {
			VectorObject obj = vram_objects[i];
			
			if ( null != obj && obj instanceof Asteroid ) {
				asteroids.add( (Asteroid)obj );
			}
		}
		// Rest des Arrays lschen
		while ( old_i < vram_objects.length ) {
			vram_objects[old_i++] = null;
		}
	}
}
