/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.wens02.Asteroid;
import de.wens02.AsteroidApp;
import de.wens02.Debug;
import de.wens02.Log;
import de.wens02.Shot;
import de.wens02.VectorObject;
import java.awt.Point;

public abstract class MovingObject
extends VectorObject {
    protected static int MOVINGOBJECT_ID = 1;
    protected int id;
    protected double dx;
    protected double dy;
    protected int x0;
    protected int y0;
    protected int x_virtual;
    protected int y_virtual;
    protected int pixelSize = 0;
    protected int squaredPixelSize = 0;
    protected int frames;
    protected int projected_frames;
    protected int projected_x;
    protected int projected_y;
    protected boolean collision = false;
    protected int collisionFrame = 0;
    protected double distance = 0.0;
    protected Point tmpPoint = new Point(0, 0);

    public MovingObject(int x, int y, int s, int type) {
        super(x, y, s, type);
        this.id = MOVINGOBJECT_ID++;
        this.x0 = this.x_virtual = x;
        this.y0 = this.y_virtual = y;
        this.frames = 1;
    }

    public double getSpeed() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public double getAlpha() {
        return Math.toDegrees(Math.atan2(this.dx, this.dy));
    }

    public void getPosition(Point p, int frameHorizon) {
        p.x = this.x + (int)((double)frameHorizon * this.dx);
        p.y = this.y + (int)((double)frameHorizon * this.dy);
        MovingObject.normalize(p);
    }

    public static void normalize(Point p) {
        while (p.x < 0) {
            p.x += 1024;
        }
        while (p.y < 0) {
            p.y += 768;
        }
        while (p.x > 1023) {
            p.x -= 1024;
        }
        while (p.y > 767) {
            p.y -= 768;
        }
    }

    public int getSquaredNormalDistance(Point p, int frameHorizon) {
        this.getPosition(this.tmpPoint, frameHorizon);
        int dx = p.x - this.tmpPoint.x;
        int dy = p.y - this.tmpPoint.y;
        return dx * dx + dy * dy;
    }

    public static int NormalDistSq(Point p1, Point p2) {
        int dx = p1.x - p2.x;
        int dy = p1.y - p2.y;
        return dx * dx + dy * dy;
    }

    public static int NormalDistSq(Point p, int x, int y) {
        int dx = p.x - x;
        int dy = p.y - y;
        return dx * dx + dy * dy;
    }

    public int getSquaredNormalDistance(Shot shot, int frameHorizon) {
        this.getPosition(this.tmpPoint, frameHorizon);
        shot.getPosition(shot.tmpPoint, frameHorizon);
        int dx = this.tmpPoint.x - shot.tmpPoint.x;
        int dy = this.tmpPoint.y - shot.tmpPoint.y;
        return dx * dx + dy * dy;
    }

    public double getTorusDistance(int vx, int vy) {
        int odx = this.x - vx;
        int ody = this.y - vy;
        while (odx > 512) {
            odx -= 1024;
        }
        while (odx < -512) {
            odx += 1024;
        }
        while (ody > 384) {
            ody -= 768;
        }
        while (ody < -384) {
            ody += 768;
        }
        return Math.sqrt(odx * odx + ody * ody);
    }

    public double getSquaredTorusDistance(Point p, int frameHorizon) {
        double odx = (double)(this.x - p.x) + (double)frameHorizon * this.dx;
        double ody = (double)(this.y - p.y) + (double)frameHorizon * this.dy;
        while (odx > 512.0) {
            odx -= 1024.0;
        }
        while (odx < -512.0) {
            odx += 1024.0;
        }
        while (ody > 384.0) {
            ody -= 768.0;
        }
        while (ody < -384.0) {
            ody += 768.0;
        }
        return odx * odx + ody * ody;
    }

    public double getTorusDistance(Point p, int frameHorizon) {
        return Math.sqrt(this.getSquaredTorusDistance(p, frameHorizon));
    }

    public double getSquaredTorusDistance(MovingObject obj, int frameHorizon) {
        double odx = (double)(this.x - obj.x) + (double)frameHorizon * (this.dx - obj.dx);
        double ody = (double)(this.y - obj.y) + (double)frameHorizon * (this.dy - obj.dy);
        while (odx > 512.0) {
            odx -= 1024.0;
        }
        while (odx < -512.0) {
            odx += 1024.0;
        }
        while (ody > 384.0) {
            ody -= 768.0;
        }
        while (ody < -384.0) {
            ody += 768.0;
        }
        return odx * odx + ody * ody;
    }

    public double getTorusDistance(MovingObject obj, int frameHorizon) {
        return Math.sqrt(this.getSquaredTorusDistance(obj, frameHorizon));
    }

    public double getTorusDistance(MovingObject obj) {
        return this.getTorusDistance(obj, 0);
    }

    public boolean shotWillHit(Point p, int frameHorizon) {
        return this.getSquaredNormalDistance(p, frameHorizon) < this.squaredPixelSize / 4;
    }

    public boolean shotWillHit(Shot shot, int frameHorizon) {
        return this.getSquaredNormalDistance(shot, frameHorizon) < this.squaredPixelSize / 4;
    }

    public void update(Point p) {
        int odx = p.x - this.x;
        int ody = p.y - this.y;
        while (odx > 512) {
            odx -= 1024;
        }
        while (odx < -512) {
            odx += 1024;
        }
        while (ody > 384) {
            ody -= 768;
        }
        while (ody < -384) {
            ody += 768;
        }
        this.x_virtual += odx;
        this.y_virtual += ody;
        if (this.frames <= 8) {
            this.dx = (double)(this.x_virtual - this.x0) / (double)this.frames;
            this.dy = (double)(this.y_virtual - this.y0) / (double)this.frames;
        }
        this.x = p.x;
        this.y = p.y;
        if (8 == this.frames && Debug.subraumpixel) {
            Log.debug(String.format("Frame#%5d: MovingObject ID#%5d: dx,dy=%5f,%5f", AsteroidApp.frame_cnt, this.id, 8.0 * this.dx, 8.0 * this.dy));
        }
        if (Debug.asteroid_projection) {
            double dist;
            if (8 == this.frames) {
                this.projected_frames = 100;
                this.projected_x = (int)((double)this.x + (double)this.projected_frames * this.dx);
                this.projected_y = (int)((double)this.y + (double)this.projected_frames * this.dy);
                while (this.projected_x < 0) {
                    this.projected_x += 1024;
                }
                while (this.projected_y < 0) {
                    this.projected_y += 768;
                }
                while (this.projected_x > 1023) {
                    this.projected_x -= 1024;
                }
                while (this.projected_y > 767) {
                    this.projected_y -= 768;
                }
            } else if (this.projected_frames > 0 && --this.projected_frames == 0 && this instanceof Asteroid && (dist = this.getTorusDistance(this.projected_x, this.projected_y)) > 2.0) {
                Log.error(String.format("Frame#%5d: PROJEKTIONSFEHLER: MovingObject ID#%5d[%4d,%4d], P=[%4d,%4d], frames=%4d, dist=%5f", AsteroidApp.frame_cnt, this.id, this.x, this.y, this.projected_x, this.projected_y, this.frames, dist));
            }
        }
        ++this.frames;
    }
}

