/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.DirectoryPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.DirectoryEditor;
import de.caff.util.settings.swing.EditorProvider;
import java.io.File;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SwingDirectoryPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements DirectoryPreferenceProperty {
    private File directory;

    public SwingDirectoryPreferenceProperty(String basicName, String baseTag, File directory) {
        super(basicName, baseTag);
        this.directory = directory;
    }

    @Override
    public void readFrom(Preferences preferences) {
        String value = preferences.get(this.getBasicName(), null);
        if (value != null) {
            this.setDirectory(new File(value));
        }
    }

    @Override
    public void storeTo(Preferences preferences) {
        if (this.directory == null) {
            preferences.remove(this.getBasicName());
        } else {
            preferences.put(this.getBasicName(), this.directory.getPath());
        }
    }

    @Override
    public EditorProvider getEditorProvider(Locale l) {
        return new DirectoryEditor(this, l);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        if (directory != null ? !directory.equals(this.directory) : this.directory != null) {
            File oldDirectory = this.directory;
            this.directory = directory;
            this.fireValueChange(this.getBasicName(), oldDirectory, directory);
        }
    }
}

