/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JMenuItem;

public class RJMenuItem
extends JMenuItem
implements Localizable {
    protected String resTag;

    public RJMenuItem(String tag) {
        this.setTag(tag);
    }

    public RJMenuItem(String tag, Locale l) {
        this.setTag(tag, l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void setTag(String tag) {
        this.setTag(tag, this.getLocale());
    }

    public void setTag(String tag, Locale l) {
        this.resTag = tag;
        this.setLocale(l);
        I18nHelper.setProperties(this, this.resTag, l);
    }

    @Override
    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l) && this.resTag != null) {
            I18nHelper.setProperties(this, this.resTag, l);
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }
}

