// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

static const int OBJ_NUMBERS[] = {0xADD, 0xB2E, 0xB32, 0xB3A, 0xB41, 0xB48, 0xB4F, 0xB56, 0xB5B, 0xB63}; 

static const int MAX_ASTEROIDS = 101;
static const int MAX_SHOTS = 8;

static const int SHOTSPEED = 8; //Geschwindikeit der eigenen Schsse in Pixel pro Frame

static const int FIRERATE = 2; //2 is highest firerate, 60 is once per second 
static const int FLEEING_DISTANCE=26;
static const int W_UFO=    145;		//Zielselektionsbonus fr UFO
static const int W_DIST=    1;		//Gewicht mit dem die Entfernung in die Zielselektion eingeht
static const double W_MOVE= 50.0;	//Gewicht mit dem der Bewegungsvektor des Ziels in die Zielselektion eingeht
static const double W_CRASH= 100.0;	//Gewicht mit dem Objekte auf Kollisionskurs in die Zielselektion eingehen
static const double W_HEAD= 100.0;	//Gewicht mit dem der Blickrichtung des Schiffs in die Zielselektion eingeht




class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int oldx; // Koordinaten des Mittelpunkts im vorigen Frame
	int oldy;
	bool tracked;
	int vx;	// ermittelte Geschwindigkeitsvektoren
	int vy;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
	int targetx, targety;	//die Position auf die man schieen msste um das Schiff zu treffen
	int target_priority;
	int crash_priority;

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;
	int oldx; // Koordinaten im vorigen Frame
	int oldy;
	bool tracked;	
	int pc;
	int vx;	// ermittelte Geschwindigkeitsvektoren
	int vy;

	void set(int x, int y, int pc);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_hx;        // Blickrichtung des Schiffes
	int ship_hy;
	int ship_vx;	    // Bewegungsvektor des Schiffes
	int ship_vy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_vx;      // Bewegungsvektor des UFOs
	int saucer_vy;	
	bool saucer_tracked;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
//	int ntargets;
//	Target targets[MAX_ASTEROIDS+1]; //can hold all asteroids and the saucer
	void clear(void);
	int score; 	//Score as it is read from the screen
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
