package objects;

import helpers.CombatStatistics;

import java.util.LinkedList;

import utils.Utils;

public abstract class TargetObject extends CombatObject {

	protected int numTargeted;
	
	protected int targetedTime;
	
	protected LinkedList<Shot> shotsFiredUpon = new LinkedList<Shot>();
	
	public TargetObject(int x, int y)
	{
		super(x, y);
		numTargeted = 0;
		targetedTime = -1;
	}
	
	public void onTargeted()
	{
		++numTargeted;
		targetedTime = CombatStatistics.TIME;
	}
	
	public void onFiredUpon(Shot shot)
	{
		shotsFiredUpon.add(shot);
	}
	
	public void onMissed(Shot shot)
	{
		if(isAlive && !shotsFiredUpon.isEmpty())
		{
			if(shot == null)
			{
				shotsFiredUpon.removeLast();
			} else {
				shotsFiredUpon.remove(shot);
			}
			--numTargeted;
			targetedTime = -1;
		}
	}
	
	public int getTimeToHit()
	{
		if(shotsFiredUpon.isEmpty())
		{
			return Integer.MAX_VALUE;
		} else {
			return shotsFiredUpon.getLast().getTimeToDestination();
		}
	}
	
	public LinkedList<Shot> getShotsFiredUpon()
	{
		return shotsFiredUpon;
	}
	
	public int getTargetedStatus() 
	{
		return numTargeted;
	}
	
	public int getFiredUponStatus()
	{
		return shotsFiredUpon.size();
	}
	
	public void update(int newX, int newY, int frameDif) {
		super.update(newX, newY, frameDif);
		updateTargetedStatus();
	}
	
	protected void updateTargetedStatus()
	{
		int numFiredUpon = shotsFiredUpon.size();
		if(numTargeted != numFiredUpon)
		{
			// Check and correct...in case of packet loss
			if(CombatStatistics.TIME - targetedTime > 2)
			{
				numTargeted = numFiredUpon;
			}
		} else if(targetedTime > -1 && CombatStatistics.TIME - targetedTime > 2 + Utils.PHOTON_TORPEDO_MIN_ALIVE_TIME) 
		{
			onMissed(null);
		}
	}
}
