package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class StatisticsPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	
	private JLabel[] scoreLabels;
	
	private JLabel[] sectorLabels;
	
	private JLabel[] asteroidsLabels;
	
	private JLabel[] shotsLabels;
	
	private JLabel[] shipLossLabels;
	
	private JLabel[] jumpsLabels;
	
	private JLabel[] ufosLabels;
	
	private JLabel[] targetRateLabels;
	
	private JLabel[] shotRateLabels;
	
	private JLabel[] hitRateLabels;
	
	private JLabel[] activityRateLabels;

	public StatisticsPanel()
	{
		super();
		setBorder(new TitledBorder(new EtchedBorder() , "Statistics"));
		setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		int lWidth = 120;
		int vWidth = 90;
		scoreLabels = createLabelPair("Score:", lWidth, "0", vWidth);
		sectorLabels = createLabelPair("Space Sector:", lWidth, "00", vWidth);
		asteroidsLabels = createLabelPair("Asteroids In View:", lWidth, "00", vWidth);
		add(Box.createRigidArea(new Dimension(0, 20)));
		shotsLabels = createLabelPair("Shots Fired:", lWidth, "0", vWidth);
		shipLossLabels = createLabelPair("Ships Lost:", lWidth, "00", vWidth);
		jumpsLabels = createLabelPair("Jumps Performed:", lWidth, "00", vWidth);
		ufosLabels = createLabelPair("Saucer Encounters:", lWidth, "00", vWidth);
		add(Box.createRigidArea(new Dimension(0, 20)));
		targetRateLabels = createLabelPair("Target Rate:", lWidth, "0.00 / second", vWidth);
		shotRateLabels = createLabelPair("Shooting Rate:", lWidth, "0.00 / second", vWidth);
		hitRateLabels = createLabelPair("Hit Rate:", lWidth, "00.00 %", vWidth);
		activityRateLabels = createLabelPair("Activity Rate:", lWidth, "00.00 %", vWidth);
	}
	
	public void updateStatus(int score, int sector, int asteroids)
	{
		String format = "%,d";
		scoreLabels[1].setText(String.format(format, score));
		format = "%02d";
		sectorLabels[1].setText(String.format(format, sector));
		format = "%02d";
		asteroidsLabels[1].setText(String.format(format, asteroids));
	}
	
	public void updateActions(int shotsFired, int shipsLost, int jumpsPerformed, int saucersEncountered)
	{
		String format = "%,d";
		shotsLabels[1].setText(String.format(format, shotsFired));
		format = "%02d";
		shipLossLabels[1].setText(String.format(format, shipsLost));
		format = "%02d";
		jumpsLabels[1].setText(String.format(format, jumpsPerformed));
		format = "%02d";
		ufosLabels[1].setText(String.format(format, saucersEncountered));
	}
	
	public void updateRatings(float targetRate, float shootingRate, float hitRate, float activityRate)
	{
		String format = "%.2f / second";
		targetRateLabels[1].setText(String.format(format, targetRate));
		format = "%.2f / second";
		shotRateLabels[1].setText(String.format(format, shootingRate));
		format = "%.2f %%";
		hitRateLabels[1].setText(String.format(format, hitRate));
		format = "%.2f %%";
		activityRateLabels[1].setText(String.format(format, activityRate));
	}
	
	public JTextArea createStaticticsArea()
	{
		JTextArea result = new JTextArea();
		result.setEditable(false);		
		result.setBorder(new EmptyBorder(5, 5, 5, 5));
		result.setAlignmentX(Component.LEFT_ALIGNMENT);
		JScrollPane pane = new JScrollPane(result);
		pane.setPreferredSize(new Dimension(300, 256));
		add(pane, BorderLayout.CENTER);
		return result;
	}
	
	public JLabel[] createLabelPair(String label, int lWidth, String value, int vWidth)
	{
		JPanel result = new JPanel();		
		JLabel[] labels = new JLabel[2];
		labels[0] = new JLabel(label);
		Dimension prefSize = labels[0].getPreferredSize();
		labels[0].setPreferredSize(new Dimension(lWidth, prefSize.height));
		labels[0].setAlignmentX(Component.LEFT_ALIGNMENT);
		labels[1] = new JLabel(value);	
		prefSize = labels[1].getPreferredSize();
		labels[1].setPreferredSize(new Dimension(vWidth, prefSize.height));
		result.setLayout(new FlowLayout(FlowLayout.LEADING, 5, 0));
		result.setAlignmentX(Component.LEFT_ALIGNMENT);
		result.add(labels[0]);
		result.add(labels[1]);
		add(result);
		return labels;
	}
}
