/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Rectangle;
import objects.CombatObject;
import utils.Tables;

public class Utils {
    public static final int COMBAT_FIELD_OFFSET_Y = 128;
    public static final int COMBAT_FIELD_WIDTH = 1024;
    public static final int COMBAT_FIELD_HEIGHT = 768;
    public static final int COMBAT_FIELD_CENTER_X = 512;
    public static final int COMBAT_FIELD_CENTER_Y = 384;
    public static final double POS_INACCURACY = 0.4375;
    public static final double PHOTON_TORPEDO_SPEED = 7.875;
    public static final int PHOTON_TORPEDO_MIN_ALIVE_TIME = 68;
    public static final int VICINITY_RANGE = 50;
    public static final int SHIP_SPAWN_X = 524;
    public static final int SHIP_SPAWN_Y = 524;
    public static final double SHIP_MAX_SPEED = 7.875;
    public static final double SHIP_ACCELERATION = 0.125;
    public static final double SHIP_DECELERATION = 0.99609375;
    public static final int EVASION_MIN_TIME = 60;
    public static final double EVASION_MIN_ANGLE_ASTEROID = 1.427996660722633;
    public static final double EVASION_OPTIMUM_ANGLE_SHOT = 1.5707963267948966;
    public static final double EVASION_MAX_DEVIATION_SHOT = 1.0471975511965976;
    public static final int MIN_BYTE_TURN = 3;
    public static final int MAX_MOVE_PRECISION = 8;
    public static final int MAX_TURN_ANGLES = 256;
    public static final double AVERAGE_TURN_ANGLE = 0.07363107781851078;
    public static final int MAX_SIMULTANEOUS_SHOTS = 4;
    public static final int MAX_SAUCER_CAMP_TIME = 60;
    public static final int TIME_LIMIT = 18000;
    public static final int EXPLOSION_DELAY = 37;
    public static final int HYPERSPACE_DELAY = 47;
    public static final Tables TABLES = new Tables();

    public static void init() {
    }

    public static int willCollideWithin(CombatObject object1, CombatObject object2, int maxTime) {
        boolean signMatchY;
        int difX = Utils.getXDif(object1.getPosX(), object2.getPosX());
        int difY = Utils.getYDif(object1.getPosY(), object2.getPosY());
        boolean xCollision = false;
        boolean yCollision = false;
        if (difX < 0) {
            if ((difX += (object1.getWidth() + object2.getWidth()) / 2) >= 0) {
                xCollision = true;
            }
        } else if ((difX -= (object1.getWidth() + object2.getWidth()) / 2) <= 0) {
            xCollision = true;
        }
        if (difY < 0) {
            if ((difY += (object1.getHeight() + object2.getHeight()) / 2) >= 0) {
                yCollision = true;
            }
        } else if ((difY -= (object1.getHeight() + object2.getHeight()) / 2) <= 0) {
            yCollision = true;
        }
        if (xCollision && yCollision) {
            return 0;
        }
        double difMoveX = object2.getMovementX() - object1.getMovementX();
        double difMoveY = object2.getMovementY() - object1.getMovementY();
        boolean signMatchX = difX >= 0 && difMoveX <= 0.0 || difX <= 0 && difMoveX >= 0.0;
        boolean bl = signMatchY = difY >= 0 && difMoveY <= 0.0 || difY <= 0 && difMoveY >= 0.0;
        if (signMatchX && signMatchY && Math.abs(difMoveX * (double)maxTime) > (double)Math.abs(difX) && Math.abs(difMoveY * (double)maxTime) > (double)Math.abs(difY)) {
            int iX = 0;
            if (difMoveX != 0.0) {
                iX = (int)Math.floor(Math.abs((double)difX / difMoveX));
            }
            int iY = 0;
            if (difMoveY != 0.0) {
                iY = (int)Math.floor(Math.abs((double)difY / difMoveY));
            }
            int i = Math.min(iX, iY);
            while (i < maxTime) {
                if (Utils.willCollideIn(object1, object2, i)) {
                    return i;
                }
                ++i;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean willCollideIn(CombatObject object1, CombatObject object2, int time) {
        Rectangle rect1 = object1.getBounds();
        Rectangle rect2 = object2.getBounds();
        double moveX = (double)time * object1.getMovementX();
        double moveY = (double)time * object1.getMovementY();
        moveX = moveX < 0.0 ? Math.floor(moveX) : Math.ceil(moveX);
        moveY = moveY < 0.0 ? Math.floor(moveY) : Math.ceil(moveY);
        rect1.translate((int)moveX, (int)moveY);
        moveX = (double)time * object2.getMovementX();
        moveY = (double)time * object2.getMovementY();
        moveX = moveX < 0.0 ? Math.floor(moveX) : Math.ceil(moveX);
        moveY = moveY < 0.0 ? Math.floor(moveY) : Math.ceil(moveY);
        rect2.translate((int)moveX, (int)moveY);
        Rectangle result = rect1.intersection(rect2);
        switch (object2.getScale()) {
            case 0: {
                return result.width + result.height > 13;
            }
            case 15: {
                return result.width + result.height > 7;
            }
            case 14: {
                return result.width + result.height > 4;
            }
        }
        return !result.isEmpty();
    }

    public static int decByteAngle(int angle) {
        if ((angle -= 3) < 0) {
            angle += 256;
        }
        return angle;
    }

    public static int incByteAngle(int angle) {
        if ((angle += 3) >= 256) {
            angle -= 256;
        }
        return angle;
    }

    public static double getCounterAngle(double angle) {
        double counterAngle = angle + Math.PI;
        if (counterAngle > Math.PI * 2) {
            counterAngle -= Math.PI * 2;
        }
        return counterAngle;
    }

    public static int getAngleIndexDif(int angle1, int angle2) {
        int angleIndexDif = angle2 - angle1;
        if (angleIndexDif < -128) {
            angleIndexDif += 256;
        } else if (angleIndexDif > 128) {
            angleIndexDif -= 256;
        }
        return angleIndexDif;
    }

    public static double getAngleDif(double angle1, double angle2) {
        double angleDif = angle2 - angle1;
        if (angleDif < -Math.PI) {
            angleDif += Math.PI * 2;
        } else if (angleDif > Math.PI) {
            angleDif -= Math.PI * 2;
        }
        return angleDif;
    }

    public static boolean isAngleReachedCCW(double curAngle, double targetAngle) {
        return curAngle > targetAngle || curAngle < 0.0 && targetAngle > 0.0;
    }

    public static boolean isAngleReachedCW(double curAngle, double targetAngle) {
        return curAngle < targetAngle || curAngle > 0.0 && targetAngle < 0.0;
    }

    public static double getXDist(double x1, double x2) {
        double xDist = x2 - x1;
        while (xDist > 512.0) {
            xDist -= 1024.0;
        }
        while (xDist < -512.0) {
            xDist += 1024.0;
        }
        return Math.abs(xDist);
    }

    public static double getYDist(double y1, double y2) {
        double yDist = y2 - y1;
        while (yDist > 384.0) {
            yDist -= 768.0;
        }
        while (yDist < -384.0) {
            yDist += 768.0;
        }
        return Math.abs(yDist);
    }

    public static int getXDif(int x1, int x2) {
        int xDif = x2 - x1;
        while (xDif > 512) {
            xDif -= 1024;
        }
        while (xDif < -512) {
            xDif += 1024;
        }
        return xDif;
    }

    public static int getYDif(int y1, int y2) {
        int yDif = y2 - y1;
        while (yDif > 384) {
            yDif -= 768;
        }
        while (yDif < -384) {
            yDif += 768;
        }
        return yDif;
    }

    public static double getDistSquare(double x1, double y1, double x2, double y2) {
        double xDist = Math.abs(x2 - x1);
        double yDist = Math.abs(y2 - y1);
        while (xDist > 512.0) {
            xDist = 1024.0 - xDist;
        }
        while (yDist > 384.0) {
            yDist = 768.0 - yDist;
        }
        return xDist * xDist + yDist * yDist;
    }
}

