/*
 * Decompiled with CFR 0.152.
 */
package objects;

import helpers.CombatHeuristics;
import objects.PreAsteroid;
import objects.TargetObject;

public class Asteroid
extends TargetObject {
    public static final int LARGE_SIZE = 64;
    public static final int MEDIUM_SIZE = 32;
    public static final int SMALL_SIZE = 16;
    protected int type;
    protected PreAsteroid child;

    public Asteroid(int x, int y, int type, int scale) {
        super(x, y);
        this.type = type;
        this.scale = scale;
        this.child = null;
        switch (scale) {
            case 0: {
                this.width = 64;
                this.height = 64;
                break;
            }
            case 15: {
                this.width = 32;
                this.height = 32;
                break;
            }
            case 14: {
                this.width = 16;
                this.height = 16;
            }
        }
    }

    public boolean hasChild() {
        return this.child != null;
    }

    public PreAsteroid getChild() {
        return this.child;
    }

    public void createChild(double distance, int timeToHit) {
        if (this.child == null) {
            this.child = new PreAsteroid(this.posX, this.posY, -1, 14, timeToHit + CombatHeuristics.getPrecisionDelay(distance, null));
        }
    }

    @Override
    public void update(int newX, int newY, int frameDif) {
        super.update(newX, newY, frameDif);
        if (this.child != null) {
            if (this.numTargeted > 0) {
                this.child.update(newX, newY, frameDif);
            } else {
                this.child.destroy();
                this.child = null;
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.child != null) {
            this.child.destroy();
            this.child = null;
        }
    }

    @Override
    public String toString() {
        String result = "Asteroid #%d {%d, %d / %.3f, %.3f / %d, %d}";
        return String.format(result, this.id, this.posX, this.posY, this.moveX, this.moveY, this.type, this.scale);
    }

    public boolean matches(int otherX, int otherY, int otherType, int otherScale, int frameDif) {
        if (this.type == otherType && this.scale == otherScale) {
            return super.matches(otherX, otherY, frameDif);
        }
        return false;
    }

    @Override
    public int getMaximumSpeed() {
        switch (this.scale) {
            case 0: {
                return 2;
            }
            case 15: {
                return 4;
            }
            case 14: {
                return 4;
            }
        }
        return 4;
    }
}

