/*
 * Decompiled with CFR 0.152.
 */
package io;

import helpers.CombatStatistics;

public class CombatControl {
    public static final int BUFFER_SIZE = 10;
    public static final byte NONE = 0;
    public static final byte HYPERSPACE = 1;
    public static final byte FIRE = 2;
    public static final byte ACCELLERATE = 4;
    public static final byte RIGHT = 8;
    public static final byte LEFT = 16;
    public static final byte START = 32;
    private byte control = 0;
    private byte[] buffer = new byte[10];
    private int curBuf = -1;
    private int packetCount;
    private int packetDif = 0;
    private int lastPacketDif = 0;

    public CombatControl() {
        this.reset();
    }

    public void accelerate() {
        this.control = (byte)(this.control | 4);
    }

    public void fire() {
        this.control = (byte)(this.control | 2);
    }

    byte getControl() {
        return this.control;
    }

    byte getPacketCount() {
        return (byte)this.packetCount;
    }

    public boolean hasAccelerated() {
        int i = this.curBuf - (this.lastPacketDif + 1);
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 4) == 4;
    }

    public boolean hasFired() {
        int i = this.curBuf - (this.lastPacketDif + 1);
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 2) == 2;
    }

    public boolean hasTurnedLeft() {
        int i = this.curBuf - (this.lastPacketDif + 1);
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 0x10) == 16;
    }

    public boolean hasTurnedRight() {
        int i = this.curBuf - (this.lastPacketDif + 1);
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 8) == 8;
    }

    public boolean isAccelerating() {
        int i = this.curBuf - this.packetDif;
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 4) == 4;
    }

    public boolean isFiring() {
        int i = this.curBuf - this.packetDif;
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 2) == 2;
    }

    public boolean isStarting() {
        int i = this.curBuf - this.packetDif;
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 0x20) == 32;
    }

    public boolean isTurningLeft() {
        int i = this.curBuf - this.packetDif;
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 0x10) == 16;
    }

    public boolean isTurningRight() {
        int i = this.curBuf - this.packetDif;
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 8) == 8;
    }

    public boolean isWarping() {
        int i = this.curBuf - this.packetDif;
        while (i < 0) {
            i += 10;
        }
        return (this.buffer[i] & 1) == 1;
    }

    void onApproval(int packetCompare) {
        if (this.packetCount < packetCompare) {
            packetCompare -= 256;
        }
        this.lastPacketDif = this.packetDif;
        this.packetDif = this.packetCount - packetCompare;
        if (this.packetDif > 0) {
            CombatStatistics.PACKET_LOSS += this.packetDif;
        }
    }

    void onSend() {
        if (++this.curBuf == 10) {
            this.curBuf = 0;
        }
        this.buffer[this.curBuf] = this.control;
        this.control = 0;
        this.packetCount = (this.packetCount + 1) % 256;
    }

    void reset() {
        int i = 0;
        while (i < 10) {
            this.buffer[i] = 0;
            ++i;
        }
        this.packetCount = 0;
        this.packetDif = 0;
    }

    void setControl(byte control) {
        this.control = control;
    }

    public void start() {
        this.control = (byte)(this.control | 0x20);
    }

    public void turnLeft() {
        this.control = (byte)(this.control | 0x10);
    }

    public void turnRight() {
        this.control = (byte)(this.control | 8);
    }

    public void hyperspace() {
        this.control = (byte)(this.control | 1);
    }

    public boolean willAccelerate() {
        return (this.control & 4) == 4;
    }

    public boolean willFire() {
        return (this.control & 2) == 2;
    }

    public boolean willTurnLeft() {
        return (this.control & 0x10) == 16;
    }

    public boolean willTurnRight() {
        return (this.control & 8) == 8;
    }
}

