unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,  Sockets;

// ################################################################################
// ################################################################################
// ################################################################################

 const wk=true;
// const wk=false;

// Const Speed=' -speed 1 -nosound';
Const Speed=' -speed 5 -video none -nosound';

Const Spieldauer=5*60*60; // in minuten

const HyperspaceTest=1;  // 1 - ohne Latenz
                         // 2 - mit latenz (internet)


// ################################################################################
// ################################################################################
// ################################################################################

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    GoTimer: TTimer;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    GroupBox2: TGroupBox;
    IP: TEdit;
    Port: TEdit;
    Label5: TLabel;
    Go: TButton;
    Endlosspiel: TCheckBox;
    Stop: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure GoTimerTimer(Sender: TObject);
    procedure GoClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure load_IP;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  neu,alt:integer;


implementation
uses tools,U_Spiel, Unit2;

{$R *.dfm}

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var f:textfile;
begin
  if spiel<>nil then begin
     Spiel.ende:=true;
     spiel.Free;
  end;
  assignfile(f,'daten\IP.txt');
  rewrite(f);
  writeln(f,ip.Text);
  writeln(f,port.Text);
  if endlosspiel.Checked then writeln(f,'Endlosspiel') else writeln(f,'einfaches Spiel');
  closefile(f);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  randomize;
  spiel:=nil;
  GoTimer.Enabled:=true;
end;

procedure TForm1.GoClick(Sender: TObject);
begin
  Go.Enabled:=false;
  Stop.Enabled:=true;
  if spiel<>nil then spiel.Free;
  Spiel:=TSpiel.Create;
  Timer1.Enabled:=true;

  while (not spiel.ende)and(spiel.spielzeit<=spieldauer+1000) do begin
     spiel.Go;
  end;

  Timer1.Enabled:=false;
  if spiel.startzeit>1000 then begin
     Timer1Timer(Sender);
     log('Punkte','Punkte: '+inttostr(spiel.Punkte)+'  Leben: '+inttostr(spiel.Leben)+'                  '+datetimetostr(spiel.startzeit));
     memo1.Lines.Add('Punkte: '+inttostr(spiel.Punkte)+'  Leben: '+inttostr(spiel.Leben)+'                  '+datetimetostr(spiel.startzeit));
     Memo1.Lines.Add('========================================================');
  end;
  Go.Enabled:=true;
  stop.Enabled:=false;
  endlosspiel.Tag:=endlosspiel.Tag-1;
  if (endlosspiel.checked)and(endlosspiel.Tag>0) then Gotimer.Enabled:=true else endlosspiel.tag:=5;
end;

procedure TForm1.GoTimerTimer(Sender: TObject);
begin
  Gotimer.Tag:=GoTimer.Tag+1;
  case gotimer.Tag of
       1: begin form2.showmodal;exit;end;
       2: begin
             load_IP;
             tool_init;
             form2.close;
             exit;
          end;
  end;

  GoTimer.Enabled:=false;
  if ip.Text<>'' then Go.Click;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  label1.Caption:='Punkte: '+inttostr(spiel.Punkte)+'            ('+inttostr(test1)+' '+inttostr(test2)+')';
  label2.Caption:='Leben: '+inttostr(spiel.leben);
  label3.Caption:='Spielzeit: '+timetostr(spiel.SpielZeit/60/24/3600)+'       Level: '+inttostr(spiel.level)+'   ( '+inttostr(spiel.LevelZeit div 60)+' sek. )';
  label4.Caption:='Latenz: '+inttostr(latenz)+'  ('+inttostr(LatenzFehler)+')  MameLatenz: '+inttostr(MameLatenz)+'  ('+inttostr(MameLatenzFehler)+')';
end;

procedure TForm1.load_IP;
var f:textfile;
    s:string;
begin

  assignfile(f,'daten\IP.txt');
  reset(f);
  readln(f,s);
  ip.Text:=s;
  readln(f,s);
  port.Text:=s;
  readln(f,s);
  endlosspiel.Checked:=s='Endlosspiel';
  closefile(f);

  if ParamCount>0 then ip.Text:=ParamStr(1);


end;


procedure TForm1.StopClick(Sender: TObject);
begin
  spiel.ende:=true;
end;

end.



