unit U_Schiff;
interface
uses SysUtils,konstanten;

type TSchiff = class(TObject)
  private
    winkelAnzeige:integer;
    procedure optimierte_Richtung_bei_keinem_schuss;
    procedure optimierte_Richtung_bei_schuss;
  protected
  public
    detect:boolean;
    xx,yy,winkel:integer;
    gesamt_schuss_anz:integer;
    const groesse=24;
          breite=12;
    constructor Create;
    destructor Destroy; override;
    procedure schiessen;
    procedure Idle;
    procedure DatenBegin;
    procedure DatenEnd;
    procedure Daten(const x,y,g:integer);
    function test_auf_treffer(w:integer;const plusschritte:integer;var schritte,obj:integer):boolean;
    function test_auf_neuen_treffer(w:integer;const plusschritte:integer;var schritte,obj:integer):boolean;
    procedure go;
    procedure optimierte_Richtung;
  end;


implementation
Uses Tools,U_Spiel,U_Asteroid_Manager,U_Key,U_Mame,U_Schuss_Manager,U_UfoSchuss_Manager,U_Schuss,U_UfoSchuss,unit1,U_asteroid;

constructor TSchiff.Create;
begin
  inherited Create;
  detect:=false;
  winkel:=0;
  gesamt_schuss_anz:=0;
end;

destructor TSchiff.Destroy;
begin
  inherited Destroy;
end;

procedure TSchiff.Idle;
begin
end;

procedure TSchiff.DatenBegin;
begin
  detect:=false;
end;

procedure TSchiff.DatenEnd;
begin
end;

procedure TSchiff.Daten(const x,y,g:integer);
var i,d:integer;
begin
  if spiel.startzeit=0 then begin
     spiel.startzeit:=now;
     Latenzfehler:=0;
     MameLatenzFehler:=0;
     spiel.Punkte:=0;
     spiel.level:=1;
     spiel.levelZeit:=0;
  end;
  detect:=true;
  xx:=x;
  yy:=y;
  winkelAnzeige:=g;

     for i:=2 to AltLatenz do begin
         if key.Verlauf[key.max-i].Rechts then winkel:=optimiereW(winkel+3);
         if key.Verlauf[key.max-i].Links  then winkel:=optimiereW(winkel-3);
     end;

     // berprfe WB
     d:=optimiereW(winkel-winkelAnzeige);

{     if (d<=252)and(d>127) then log('','WinkelByte Korektor inc  '+inttostr(winkel)+'/'+inttostr(winkelAnzeige)+'/'+inttostr(256-d));
     if (d>=4)and(d<128) then log('','WinkelByte Korektor dec  '+inttostr(winkel)+'/'+inttostr(winkelAnzeige)+'/'+inttostr(0-d));{}
     while (d<=252)and(d>127) do begin winkel:=optimiereW(winkel+3);d:=optimiereW(winkel-winkelAnzeige);end;
     while (d>=4)and(d<128) do begin  winkel:=optimiereW(winkel-3);d:=optimiereW(winkel-winkelAnzeige);end;


     // neue richtung bestimmen
     for i:=1 to latenz do begin
         if key.Verlauf[key.max-i].Rechts then winkel:=optimiereW(winkel-3);
         if key.Verlauf[key.max-i].Links  then winkel:=optimiereW(winkel+3);
     end;


end;

procedure TSchiff.schiessen;
var schritte,obj:integer;
begin
  if (not detect)or(key.Schuss)or(key.Verlauf[key.max-1].Schuss)or(schuss.anz>=4) then exit;
  if not test_auf_neuen_treffer(winkel,0,schritte,obj) then exit;
  if (schritte<1) or(obj<0) then exit;
  if key.obj<0 then inc(schuss.anz);
  key.Schuss:=true;
  key.obj:=obj;
  key.obj_schritte:=schritte;
  asteroid.Asteroid[obj].SchussCounter:=schritte+1;
  asteroid.Asteroid[obj].SchussBegin:=schritte+1;
  schuss.Berechne_SchussCountdown;

  if (obj>0)and(asteroid.Asteroid[obj].groesse=Asteroid_Gross) and(schuss.SchussCountdown<6)and(length(asteroid.Asteroid[obj].Zeit)>asteroid.Asteroid[obj].alter+schritte+2) then asteroid.set_Attrappe(asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+2].x,asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+2].y,Asteroid_Mittel,6);
  if (obj>0)and(asteroid.Asteroid[obj].groesse=Asteroid_Gross) and(schuss.anz<3)and(length(asteroid.Asteroid[obj].Zeit)>asteroid.Asteroid[obj].alter+schritte+4) then asteroid.set_Attrappe(asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+4].x,asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+4].y,Asteroid_Mittel,6);
  if (obj>0)and(asteroid.Asteroid[obj].groesse=Asteroid_Mittel)and(schuss.SchussCountdown<6)and(length(asteroid.Asteroid[obj].Zeit)>asteroid.Asteroid[obj].alter+schritte+2) then asteroid.set_Attrappe(asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+2].x,asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+2].y,Asteroid_Klein,6);
  if (obj>0)and(asteroid.Asteroid[obj].groesse=Asteroid_Mittel)and(schuss.anz<3)and(length(asteroid.Asteroid[obj].Zeit)>asteroid.Asteroid[obj].alter+schritte+4) then asteroid.set_Attrappe(asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+4].x,asteroid.Asteroid[obj].Zeit[asteroid.Asteroid[obj].alter+schritte+4].y,Asteroid_Klein,6);

end;


function TSchiff.test_auf_treffer(w:integer;const plusschritte:integer;var schritte,obj:integer):boolean;
var o,i:integer;
    x,y:integer;
begin
  result:=false;obj:=-1;schritte:=-1;
  w:=OptimiereW(w);
  for i:=2 to 69 do begin
      x:=optimiereX(schuss_tabelle[w,i].x+xx);
      y:=optimiereY(schuss_tabelle[w,i].y+yy);
      for o:=0 to Asteroid.max do
          if (asteroid.Asteroid[o].Active)
             and ((asteroid.Asteroid[o].SchussCounter<=0)or(asteroid.Asteroid[o].SchussCounter>=i+plusschritte))
              and (length(asteroid.Asteroid[o].Zeit)>asteroid.Asteroid[o].alter+i+plusschritte)
               and (istreffer(x,y,asteroid.Asteroid[o].Zeit[asteroid.Asteroid[o].alter+i+plusschritte].x,asteroid.Asteroid[o].Zeit[asteroid.Asteroid[o].alter+i+plusschritte].y,asteroid.Asteroid[o].groesse)) then begin
                   // Treffer;
                   schritte:=i;
                   obj:=o;
                   result:=true;
                   exit;
      end;
  end;
end;

function TSchiff.test_auf_neuen_treffer(w:integer;const plusschritte:integer;var schritte,obj:integer):boolean;
begin
  result:=schiff.test_auf_treffer(w,plusschritte,schritte,obj);
  if (result)and(asteroid.Asteroid[obj].SchussCounter>0) then result:=false;
end;



procedure TSchiff.optimierte_Richtung_bei_keinem_schuss;
var obj,schritte:integer;
    wb:integer;
begin
  wb:=Schiff.winkel;
  if key.Links then begin
     if schiff.test_auf_neuen_treffer(wb+3,1,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb+0,1,schritte,obj) then begin key.Links:=false; key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb-3,1,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
     exit;
  end;
  if key.rechts then begin
     if schiff.test_auf_neuen_treffer(wb-3,1,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
     if schiff.test_auf_neuen_treffer(wb+0,1,schritte,obj) then begin key.Links:=false; key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb+3,1,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
     exit;
  end;
  if schiff.test_auf_neuen_treffer(wb+0,1,schritte,obj) then begin key.Links:=false; key.Rechts:=false; exit;end;
  if schiff.test_auf_neuen_treffer(wb-3,1,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
  if schiff.test_auf_neuen_treffer(wb+3,1,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
end;

procedure TSchiff.optimierte_Richtung_bei_schuss;
var obj,schritte:integer;
    wb:integer;
begin
  wb:=Schiff.winkel;
  if key.Links then begin
     if schiff.test_auf_neuen_treffer(wb+6,2,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb+3,2,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
//     if schiff.test_auf_neuen_treffer(wb+0,2,schritte,obj) then begin key.Links:=false; key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb-3,2,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
     if schiff.test_auf_neuen_treffer(wb-6,2,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
     exit;
  end;
  if key.Links then begin
     if schiff.test_auf_neuen_treffer(wb-6,2,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
     if schiff.test_auf_neuen_treffer(wb-3,2,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
//     if schiff.test_auf_neuen_treffer(wb+0,2,schritte,obj) then begin key.Links:=false; key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb+3,2,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
     if schiff.test_auf_neuen_treffer(wb+6,2,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
     exit;
  end;
  if schiff.test_auf_neuen_treffer(wb+0,2,schritte,obj) then begin key.Links:=false; key.Rechts:=false; exit;end;
  if schiff.test_auf_neuen_treffer(wb+3,2,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
  if schiff.test_auf_neuen_treffer(wb-3,2,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
  if schiff.test_auf_neuen_treffer(wb+6,2,schritte,obj) then begin key.Links:=true;  key.Rechts:=false; exit;end;
  if schiff.test_auf_neuen_treffer(wb-6,2,schritte,obj) then begin key.Links:=false; key.Rechts:=true; exit;end;
end;


procedure TSchiff.optimierte_Richtung;
begin
  if schuss.anz>=4 then exit;
  if not Key.Schuss then optimierte_Richtung_bei_keinem_schuss
                    else optimierte_Richtung_bei_schuss;
end;


procedure TSchiff.go;
begin
end;




end.
