unit U_Mame;

interface
uses StrUtils, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
     Dialogs, StdCtrls,  ExtCtrls,Sockets,Konstanten,SyncObjs;


type TVektor=array[0..512]of word;
type
  TMameThread = class(TThread)
  private
    udp: TUdpSocket;
    V:Tvektor;
    FSenden:string;
    function empfangen:boolean;
    procedure Xsenden;
    procedure addTempDaten(const x,y,g:integer;const typ:TTyp);
    procedure VektorAnalyse;
  protected
    procedure senden(const daten:string);
    constructor Create(Horst,Port,LocalPort:string);
    procedure Execute; override;
  public
  end;


type TMame = class(TObject)
  private
    MameThread:TMameThread;
    letzte_senden_time:double;
    procedure SingleThread;
    procedure MultiThread;
    procedure schliesse_MAME;
    procedure starte_MAME;
  protected
  public
    Daten:integer;
    ThreadEnde:boolean;
    constructor Create;
    destructor Destroy; override;
    procedure Idle;
    procedure Analyse;
    procedure senden0;
    procedure sendenKey(key:byte);
    procedure sendenName(s:string);

  end;

implementation
Uses U_Spiel,U_Asteroid_Manager,U_Asteroid,U_Key,U_Schiff,U_Schuss_Manager,U_UfoSchuss_Manager,U_UfoSchuss,U_Schuss,
     tlhelp32,Tools,unit1,shellAPI;

var Temp_Daten:array[0..1024]of TVektordaten;
    Temp_Max:integer;
    Temp_Leben:integer;
    Temp_Punkte:integer;
    Temp_Counter,Temp_MameCounter:integer;
    Temp_Schiff_detect:boolean;

    latenz_simulation_array:array of array of byte;
    stopbit:byte;


procedure TMame.SingleThread;
label ts1;
begin
  asm
ts1:
    mov al,1
    xchg al,stopbit
    cmp al,0
    jnz ts1
  end;
end;

procedure TMame.MultiThread;
begin
  asm
    mov stopbit,0
  end;
end;


constructor TMame.Create;
begin
  inherited Create;
  Daten:=0;
  ThreadEnde:=false;
  letzte_senden_time:=0;
  counter:=0;
  Latenz:=1;
  AltLatenz:=1;
  LatenzFehler:=0;
  MameLatenzFehler:=0;
  MameLatenz:=1;
  setlength(latenz_simulation_array,0,2);// latenz_simulation ausgeschaltet
  schliesse_MAME;
  if form1.ip.text='127.0.0.1' then starte_MAME;

//  MameThread:=TMameThread.Create('127.0.0.1','1979','1980');
  MameThread:=TMameThread.Create(form1.IP.text,form1.port.text,'1981');

//  setlength(latenz_simulation_array,2,2);
end;

procedure LatenzSimulation(var key,C:byte);
var x,y:integer;
begin
  if length(latenz_simulation_array)<=1 then exit;
  for x:=0 to length(latenz_simulation_array)-2 do for y:=0 to 1 do latenz_simulation_array[x,y]:=latenz_simulation_array[x+1,y];
  latenz_simulation_array[length(latenz_simulation_array)-1,0]:=key;
  latenz_simulation_array[length(latenz_simulation_array)-1,1]:=c;
  if random(60)=0 then x:=0 else x:=1;
  key:=latenz_simulation_array[x,0];
  c:=latenz_simulation_array[x,1];
end;

destructor TMame.Destroy;
begin
  while not ThreadEnde do begin sleep(1);end;
  sleep(1);
//  MameThread.Terminate;
  schliesse_MAME;
  inherited Destroy;
end;



procedure KillIt(dwProcID: DWORD);
var hProcess : Cardinal;
begin
  hProcess := OpenProcess(SYNCHRONIZE or PROCESS_TERMINATE, False, dwProcID);
  TerminateProcess(hProcess, 0);
end;

procedure TMame.schliesse_MAME;
var
  hProcSnap: THandle;
  pe32: TProcessEntry32;
begin
  try
    hProcSnap := CreateToolHelp32SnapShot(TH32CS_SNAPPROCESS, 0);
    if hProcSnap = INVALID_HANDLE_VALUE then exit;
    pe32.dwSize := SizeOf(ProcessEntry32);
    if Process32First(hProcSnap, pe32) then
      while Process32Next(hProcSnap, pe32) do begin
            if pos('mameaster.exe',pe32.szExeFile)>0 then begin KillIt(pe32.th32ProcessID);end;
      end;
    CloseHandle(hProcSnap);
  except end;
end;

procedure TMame.starte_MAME;
var datei,parameter:string;
begin
  datei:='..\ct_mame\mameaster.exe';
  parameter:='asteroid -window  -skip_gameinfo'+speed;
  ShellExecute(Application.Handle, 'open' ,PChar(ExtractFilename(datei)), PChar(Parameter), PChar(ExtractFilePath(datei)), sw_ShowNormal);
end;



procedure TMame.Idle;
begin
  if now-letzte_senden_time>=sek then begin
    if (spiel.startzeit=0) then begin
       sendenkey(0);sleep(20); sendenName('Falk'); sleep(20);sendenkey($20);
    end;
  end;


end;

procedure TMame.Analyse;
var x:integer;
begin
  if (Mame.Daten<1)or(Mame.Daten>2) then exit;
  while Mame.Daten<>2 do begin {application.ProcessMessages;{}end;
  Mame.Daten:=3;


  inc(counter);altLatenz:=Latenz;
  Latenz:=(counter and $ff)-Temp_Counter;
  while Latenz<0 do inc(Latenz,256);
  if Latenz<>1 then begin
     inc(LatenzFehler);
//     form1.Memo1.Lines.Add('Latenz '+inttostr(spiel.levelzeit))
  end;

  MameLatenz:=Temp_MameCounter-MameCounter;
  while MameLatenz<0 do inc(MameLatenz,256);
  MameCounter:=Temp_MameCounter;
  if MameLatenz<>1 then inc(MameLatenzFehler);

  if MameLatenz>=8 then begin Mame.Daten:=0;exit;end;


  Spiel.DatenBegin;
  Schiff.DatenBegin;
  Schuss.DatenBegin;
  UfoSchuss.DatenBegin;
  Asteroid.DatenBegin;
  Explosion.DatenBegin;
  Ki.DatenBegin;
  Key.DatenBegin;


  spiel.setPunkte(Temp_punkte);
  spiel.setLeben(Temp_leben);
  for x:=0 to Temp_max-1 do begin
      case Temp_Daten[x].typ of
        Typ_Schuss:Schuss.Daten(Temp_Daten[x].x,Temp_Daten[x].y);
        Typ_Schiff:Schiff.Daten(Temp_Daten[x].x,Temp_Daten[x].y,Temp_Daten[x].g);
        Typ_Explosion3:Explosion.Daten(Temp_Daten[x].x,Temp_Daten[x].y,3);
        Typ_Explosion2:Explosion.Daten(Temp_Daten[x].x,Temp_Daten[x].y,2);
        Typ_Explosion1:Explosion.Daten(Temp_Daten[x].x,Temp_Daten[x].y,1);
        Typ_Explosion0:Explosion.Daten(Temp_Daten[x].x,Temp_Daten[x].y,0);
        Typ_Asteroid1:Asteroid.Daten(Temp_Daten[x].x,Temp_Daten[x].y,Temp_Daten[x].g,Temp_Daten[x].typ);
        Typ_Asteroid2:Asteroid.Daten(Temp_Daten[x].x,Temp_Daten[x].y,Temp_Daten[x].g,Temp_Daten[x].typ);
        Typ_Asteroid3:Asteroid.Daten(Temp_Daten[x].x,Temp_Daten[x].y,Temp_Daten[x].g,Temp_Daten[x].typ);
        Typ_Asteroid4:Asteroid.Daten(Temp_Daten[x].x,Temp_Daten[x].y,Temp_Daten[x].g,Temp_Daten[x].typ);
        Typ_UFO:Asteroid.Daten(Temp_Daten[x].x,Temp_Daten[x].y,Temp_Daten[x].g,Temp_Daten[x].typ);
      end;
  end;
  Mame.Daten:=0;

  Schiff.DatenEnd;
  Schuss.DatenEnd;
  UfoSchuss.DatenEnd;
  Asteroid.DatenEnd;
  Ki.DatenEnd;
  Key.DatenEnd;
  Explosion.DatenEnd;
  Spiel.DatenEnd;

end;

procedure TMame.senden0;
begin
  MameThread.senden('ctmame'+chr(0)+chr(0));
  letzte_senden_time:=now;
end;

procedure TMame.sendenKey(key:byte);
var c:byte;
begin
  if spiel.ende then exit;
  c:=counter and $ff;

  LatenzSimulation(key,c); // Latenz Simulation wenn array von latenz_simulation >=2 ist

  MameThread.senden('ctmame'+chr(key)+chr(c));
  letzte_senden_time:=now;
end;

procedure TMame.sendenName(s:string);
begin
  s:='ctname'+copy(s,1,32);
  while length(s)<38 do s:=s+chr(0);
  MameThread.senden(s);
  letzte_senden_time:=now;
end;


// ************  Thread  *************************
function TMameThread.empfangen:boolean;
var i:integer;
    j:integer;
    s:string;
begin
  try
    i:=udp.ReceiveBuf(V[0],sizeof(V));
    result:=i=1026;
    if i=11 then begin
       s:='';
       for j:=0 to 5 do s:=s+chr(v[j]and $ff)+chr(v[j] shr 8);
       if copy(s,1,9)='game over' then spiel.ende:=true; // else  form1.Memo1.Lines.Add('UDP '+inttostr(i)+'  '+s);
    end;
  except
    result:=false;
  end;
end;

procedure TMameThread.senden(const daten:string);
begin
  Mame.SingleThread;
  Fsenden:=daten;
  Mame.MultiThread;
end;

procedure TMameThread.Xsenden;
var s:string;
begin
  Mame.SingleThread;
  s:=Fsenden;
  if s<>'' then Fsenden:='';
  Mame.MultiThread;
  if s<>'' then udp.Sendln(s,'');
end;

constructor TMameThread.Create(Horst,Port,LocalPort:string);
begin
  inherited Create(true);
//  Priority := tpIdle;
  freeonterminate:=true;

  udp:=TUdpSocket.Create(nil);
  udp.BlockMode:=bmNonBlocking;
  udp.RemoteHost:=Horst;
  udp.RemotePort:=Port;
  udp.LocalPort:=LocalPort;
  udp.Active:=true;

  Resume;
end;


procedure TMameThread.Execute;
begin
  while not spiel.ende do begin
    try
      Xsenden;
    except end;
    try
      if empfangen then begin
         try
            while Mame.Daten=3 do if spiel.ende then break;
            Mame.Daten:=1;
            VektorAnalyse;
            Mame.Daten:=2;
         except Mame.Daten:=0;end;
      end;
    except Mame.Daten:=0;end;
  end;
  udp.Free;
  Mame.ThreadEnde:=true;
end;

procedure TMameThread.addTempDaten(const x,y,g:integer;const typ:TTyp);
begin
  Temp_Daten[Temp_Max].x:=optimiereX(x);
  Temp_Daten[Temp_Max].y:=optimiereY(y);
  Temp_Daten[Temp_Max].g:=g;
  Temp_Daten[Temp_Max].typ:=typ;
  inc(Temp_Max);
end;

procedure TMameThread.VektorAnalyse;
var w1,w2:word;
    OP:byte;
    p:integer;
    Vx,Vy,GSF,Z,X,Y:integer;
    SchiffTempX,SchiffTempY:integer;
begin
  Temp_max:=0;
  Temp_punkte:=0;
  Temp_leben:=0;
  VX:=0;VY:=0;GSF:=0;
  SchiffTempX:=-99999;SchiffTempY:=-99999;Temp_Schiff_detect:=false;
  P:=1;

  // lade counter
  Temp_Counter:=V[512] shr 8 and $ff;
  Temp_MameCounter:=V[512] and $ff;

  // obj. finden
  repeat
    if p<512 then begin w1:=V[p];inc(p);end else w1:=0;
    OP:=w1 shr 12;
    if (OP<=$A)and(p<512) then begin w2:=V[p];inc(p);end else w2:=0;

    if OP<=$9 then begin // langer Vektor
       Y:=(w1 and $3ff)*(1-w1 shr 9 and 2);
       X:=(w2 and $3ff)*(1-w2 shr 9 and 2);
       Z:=w2 shr 12;
       if (x=0)and(y=0)and(Z=15) then addTempDaten(vx,vy,1,Typ_Schuss); // Schu

       // Schiff
       if (not Temp_Schiff_detect)and(op=$6)and(Z=12)and(x<>0)and(y<>0) then begin
          if SchiffTempX=-99999 then begin
             SchiffTempX:=X;
             SchiffTempy:=Y;
          end else begin
             Temp_Schiff_detect:=true;
             addTempDaten(VX,VY,berechne_schiff_richtung(SchiffTempX-X,SchiffTempY-Y),Typ_Schiff);
          end;
       end else SchiffTempX:=-99999;
    end;
    if (op<>$6)then SchiffTempX:=-99999;
    if OP=$A then begin VY:=w1 and 1023;VX:=w2 and 1023;GSF:=w2 shr 12;end;
    if OP=$C then begin // SubRoutinen
       case (w1 and $0FFF)of
            $880: addTempDaten(vx,vy,0,Typ_Explosion3);
            $896: addTempDaten(vx,vy,0,Typ_Explosion2);
            $8B5: addTempDaten(vx,vy,0,Typ_Explosion1);
            $8D0: addTempDaten(vx,vy,0,Typ_Explosion0);
            $8F3: addTempDaten(vx,vy,Asteroidgroesse[GSF],Typ_Asteroid1);
            $8FF: addTempDaten(vx,vy,Asteroidgroesse[GSF],Typ_Asteroid2);
            $90D: addTempDaten(vx,vy,Asteroidgroesse[GSF],Typ_Asteroid3);
            $91A: addTempDaten(vx,vy,Asteroidgroesse[GSF],Typ_Asteroid4);
            $929: addTempDaten(vx,vy,UFOGroesse[GSF],Typ_UFO);
            $A6D: inc(Temp_Leben);
       end;
       if (VX=100)and(VY=876)and(GSF=1) then begin
          case (w1 and $0FFF)of
            $ADD: Temp_Punkte:=temp_Punkte*10+0;
            $B2E: Temp_Punkte:=temp_Punkte*10+1;
            $B32: Temp_Punkte:=temp_Punkte*10+2;
            $B3A: Temp_Punkte:=temp_Punkte*10+3;
            $B41: Temp_Punkte:=temp_Punkte*10+4;
            $B48: Temp_Punkte:=temp_Punkte*10+5;
            $B4F: Temp_Punkte:=temp_Punkte*10+6;
            $B56: Temp_Punkte:=temp_Punkte*10+7;
            $B5B: Temp_Punkte:=temp_Punkte*10+8;
            $B63: Temp_Punkte:=temp_Punkte*10+9;
          end;
       end;
    end;
  until (OP=$B)or(p>=sizeof(V));
end;




end.
