unit U_Ki_Manager;

interface
uses U_Ki1,U_Ki2,U_Ki3,U_Ki4,U_Ki5,U_Ki6,U_Ki7,U_Ki8,U_KiZ;

type TKi_Manager = class(TObject)
  private
    Ki1:TKi1;
    Ki2:TKi2;
    Ki3:TKi3;
    Ki4:TKi4;
    Ki5:TKi5;
    Ki6:TKi6;
    Ki7:TKi7;
    Ki8:TKi8;
    procedure teste_Autoschuss;
    procedure ueberpruefe_Ziel;
    procedure Zielschuss;
  protected
  public
    ziel:integer;
    optimiere_Richtung:boolean;
    AutoSchuss:boolean;
    constructor Create;
    destructor Destroy; override;
    procedure Idle;
    procedure Go;
    procedure DatenBegin;
    procedure DatenEnd;
  end;
var KiZ:TKiZ;


implementation
Uses Tools,U_Spiel,U_Asteroid_Manager,U_Asteroid,U_Key,U_Mame,U_Schiff,U_Schuss_Manager,U_UfoSchuss_Manager,U_UfoSchuss,U_Schuss,
     math,unit1;




constructor TKi_Manager.Create;
begin
  inherited Create;
  ziel:=-1;
  KiZ:=TKiZ.Create;
  Ki1:=TKi1.Create;
  Ki2:=TKi2.Create;
  Ki3:=TKi3.Create;
  Ki4:=TKi4.Create;
  Ki5:=TKi5.Create;
  Ki6:=TKi6.Create;
  Ki7:=TKi7.Create;
  Ki8:=TKi8.Create;
end;

destructor TKi_Manager.Destroy;
begin
  Ki8.Free;
  Ki7.Free;
  Ki6.Free;
  Ki5.Free;
  Ki4.Free;
  Ki3.Free;
  Ki2.Free;
  Ki1.Free;
  KiZ.Free;
  inherited Destroy;
end;

procedure TKi_Manager.Idle;
begin
  if Mame.Daten=0 then KiZ.Idle;
  if Mame.Daten=0 then Ki1.Idle;
  if Mame.Daten=0 then Ki2.Idle;
  if Mame.Daten=0 then Ki3.Idle;
  if Mame.Daten=0 then Ki4.Idle;
  if Mame.Daten=0 then Ki5.Idle;
  if Mame.Daten=0 then Ki6.Idle;
  if Mame.Daten=0 then Ki7.Idle;
  if Mame.Daten=0 then Ki8.Idle;
end;

procedure TKi_Manager.DatenBegin;
begin
{  KiZ.DatenBegin;
  Ki1.DatenBegin;
  Ki2.DatenBegin;
  Ki3.DatenBegin;
  Ki4.DatenBegin;
  Ki5.DatenBegin;
  Ki6.DatenBegin;
  Ki7.DatenBegin;
  Ki8.DatenBegin;}
end;

procedure TKi_Manager.DatenEnd;
begin
{  KiZ.DatenEnd;
  Ki1.DatenEnd;
  Ki2.DatenEnd;
  Ki3.DatenEnd;
  Ki4.DatenEnd;
  Ki5.DatenEnd;
  Ki6.DatenEnd;
  Ki7.DatenEnd;
  Ki8.DatenEnd;}
end;

procedure TKi_Manager.teste_Autoschuss;
var schritte,obj:integer;
begin
  if (not autoschuss)or(schuss.anz>=4)or(key.Schuss) then exit;
  if not Schiff.test_auf_treffer(schiff.winkel,0,schritte,obj) then exit;

  schiff.schiessen;
  ueberpruefe_Ziel;
end;

procedure TKi_Manager.ueberpruefe_Ziel;
begin
  if ziel<0 then exit;
  if (not asteroid.Asteroid[ziel].Active)or(asteroid.Asteroid[ziel].SchussCounter>0)or(asteroid.Asteroid[ziel].Treffer_Schritte>300) then begin ziel:=-1;exit;end;
  if spiel.spielzeit+asteroid.asteroid[ziel].Treffer_schritte>18000 then begin ziel:=-1;exit;end;
end;

procedure TKi_Manager.Zielschuss;
var schritte,obj:integer;
var winkel,d:integer;
begin
  if (ziel<0)or (schuss.anz>=4)or (key.Schuss) then exit;
  if not Schiff.test_auf_treffer(schiff.winkel,0,schritte,obj) then exit;
  if ziel=obj then begin schiff.schiessen;ueberpruefe_Ziel;exit;end;

  winkel:=asteroid.Asteroid[ziel].Treffer_Winkel;
  d:=berechne_richtungsdifferenz(schiff.winkel,winkel);
  if d=0 then begin schiff.schiessen;ueberpruefe_Ziel;exit;end;
end;


procedure TKi_Manager.Go;
var winkel,d:integer;
begin
  if not schiff.detect then exit;
  ueberpruefe_Ziel;
  Zielschuss;
  teste_Autoschuss;


  ziel:=-1;
  autoschuss:=true;
  optimiere_Richtung:=true;


  KiZ.Go;  // optimale Schuss
  Ki2.Go;  // 1. schuss
  Ki4.Go;
  Ki6.Go;
  Ki7.Go;
  if ziel<0 then Ki8.Go;
//  if ziel<0 then Ki1.Go;  // alte Ki

  if (ziel<0)or(asteroid.Asteroid[ziel].Treffer_Schritte>70) then begin autoschuss:=true;end;
  Ki3.Go; // UFO-jagt
  Ki5.Go; // Ufo-Schuss ausweichen


  teste_Autoschuss;

  if (ziel>=0)and(asteroid.Asteroid[ziel].Treffer_Schritte<300) then begin
     winkel:=asteroid.Asteroid[ziel].Treffer_Winkel;
     d:=berechne_richtungsdifferenz(schiff.winkel,winkel);
     if d>0 then begin key.Rechts:=true;key.Links:=false;end;
     if d<0 then begin key.links:=true;key.Rechts:=false;end;
  end;

  if optimiere_Richtung then schiff.optimierte_Richtung;
end;




end.
