// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util;

/**
 *  An ordered pair of objects of the same type.
 */
public class Pair<T>
{
  /** First object. */
  public final T first;
  /** Second object. */
  public final T second;

  /**
   *  Constructor.
   *  @param first  first object
   *  @param second second object
   */
  public Pair(T first, T second)
  {
    this.first = first;
    this.second = second;
  }

  public boolean equals(Object o)
  {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Pair)) {
      return false;
    }

    Pair pair = (Pair)o;

    if (first != null ? !first.equals(pair.first) : pair.first != null) {
      return false;
    }
    if (second != null ? !second.equals(pair.second) : pair.second != null) {
      return false;
    }

    return true;
  }

  public int hashCode()
  {
    int result;
    result = (first != null ? first.hashCode() : 0);
    result = 31 * result + (second != null ? second.hashCode() : 0);
    return result;
  }

  /**
   *  Equals a given object either the first or the second object?
   *  @param o object
   *  @return the answer
   */
  public boolean contains(T o)
  {
    return first != null ? first.equals(o) : o == null || (second != null && second.equals(o));
  }
}
