/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameData;
import de.caff.asteroid.HallOfFameFiller;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import java.awt.Point;

public class SampleAsteroidPlayer
implements FrameListener,
GameData {
    private static int distenceFactor = 3000;
    private static int rotationFactor = 30;
    private static int AstBulletFactor = 2000000;
    private static int directionToShotDM = 500;
    private static int directionToShot = 20000;
    private static int directionToShotSave = 5000;
    private static int maxTargetDistence = 800;
    private static int ufoPrioFactor = 50000;
    private static int minBulletsOnSceen = 0;
    private static int safeAsteroidFactor = 0;
    private static int bulletSpeed = 8;
    private static int bulletLifeTime = 70;
    private static int hyperDirectionMin = 3000;
    private static int hyperDirectionMax = 100000;
    private static int hyperBullets = 3;
    private static int hyperSizeMin = 31;
    private static int hyperSizeMax = 34;
    private static int bulletSeekSize = 11;
    private static int bulletSeekFactor = 8;
    private static double shipWinkel = 4.21875;
    private static boolean ufoCamping = false;
    private static int scoreToCamp = 30000;
    private boolean shot;
    private Communication com;

    public SampleAsteroidPlayer(Communication com) {
        this.com = com;
        com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new SimpleVelocityPreparer(), new ScoreFixer()}));
        com.addFrameListener(new HallOfFameFiller(com, "bo"));
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        if (frame != null) {
            SpaceShip ship = frame.getSpaceShip();
            boolean doShot = true;
            int direction = -1;
            int unsignedDirection = -1;
            int frameInFuture = -1;
            if (ship != null) {
                MovingGameObject target = SampleAsteroidPlayer.findNearestTarget(ship, frame);
                if (target == null) {
                    if (!ufoCamping || frame.getScore() < scoreToCamp) {
                        if (frame.getTargetCount() > 0) {
                            this.com.pushButton(4);
                        } else {
                            this.com.pushButton(16);
                            doShot = false;
                        }
                    } else {
                        doShot = false;
                    }
                } else {
                    frameInFuture = 1;
                    Point delta = ship.getDelta(target);
                    MovingGameObject nearestObject = SampleAsteroidPlayer.findRealNearestTarget(ship, frame);
                    Point delta2 = nearestObject != null ? ship.getDelta(nearestObject) : delta;
                    int dist2 = delta2.x * delta2.x + delta2.y * delta2.y;
                    while (delta.x * delta.x + delta.y * delta.y > (bulletSpeed * frameInFuture + bulletSpeed / 2) * (bulletSpeed * frameInFuture + bulletSpeed / 2) && frameInFuture < bulletLifeTime) {
                        delta = ship.getDelta(target, frameInFuture);
                        ++frameInFuture;
                    }
                    direction = ship.getDirX() * delta.y - ship.getDirY() * delta.x;
                    unsignedDirection = direction < 0 ? -direction : direction;
                    MovingGameObject enemyBullet = SampleAsteroidPlayer.findNearestBullet(ship, frame);
                    int enemyBulletDist = -1;
                    if (enemyBullet != null) {
                        Point enemyBulletDelta = ship.getDelta(enemyBullet);
                        enemyBulletDist = enemyBulletDelta.x * enemyBulletDelta.x + enemyBulletDelta.y * enemyBulletDelta.y;
                    }
                    if (SampleAsteroidPlayer.needHyperSpace(ship, frame) || enemyBulletDist != -1 && enemyBulletDist < hyperSizeMin * hyperSizeMin) {
                        this.com.pushButton(1);
                        return;
                    }
                    if (unsignedDirection > directionToShot) {
                        doShot = false;
                    }
                    if (unsignedDirection > directionToShotDM || !this.shot) {
                        if (direction > 0) {
                            this.com.pushButton(16);
                        } else {
                            this.com.pushButton(8);
                        }
                    }
                }
                if (frame.getBulletCount() < minBulletsOnSceen) {
                    doShot = true;
                }
                if (!doShot && this.shot) {
                    this.shot = false;
                }
                this.com.setButton(2, this.shot);
                this.shot = !this.shot;
            }
        }
    }

    private static MovingGameObject findNearestTarget(SpaceShip ship, FrameInfo info) {
        int dist2;
        if (ufoCamping && info.getAsteroidCount() == 1 && info.getScore() > scoreToCamp) {
            return info.getUfo();
        }
        MovingGameObject nearest = null;
        int minDist2 = maxTargetDistence * maxTargetDistence;
        for (Asteroid ast : info.getAsteroids()) {
            Point delta = ship.getDelta(ast);
            int rotationNeed = (ship.getDirX() * delta.y - ship.getDirY() * delta.x) / rotationFactor;
            if (rotationNeed < 0) {
                rotationNeed *= -1;
            }
            int dist22 = ship.getSquaredDistance(ast) - ast.getSquaredSize() + rotationNeed;
            if (ship.getSquaredDistance(ast) > ship.getSquaredDistanceInNextFrame(ast)) {
                dist22 += safeAsteroidFactor;
            }
            MovingGameObject enemyBullet = SampleAsteroidPlayer.findNearestBullet(ast, info);
            int enemyBulletDist = -1;
            int frameInFuture = 1;
            if (enemyBullet != null) {
                Point enemyBulletDelta = ast.getDelta(enemyBullet);
                enemyBulletDist = enemyBulletDelta.x * enemyBulletDelta.x + enemyBulletDelta.y * enemyBulletDelta.y;
                while (enemyBulletDist > (bulletSeekSize + ast.getSize() / bulletSeekFactor) * (bulletSeekSize + ast.getSize() / bulletSeekFactor) && frameInFuture < bulletLifeTime) {
                    enemyBulletDelta = ast.getDelta(enemyBullet, frameInFuture);
                    enemyBulletDist = enemyBulletDelta.x * enemyBulletDelta.x + enemyBulletDelta.y * enemyBulletDelta.y;
                    ++frameInFuture;
                }
                if (enemyBulletDist != -1 && ufoCamping && info.getAsteroidCount() > 2 && enemyBulletDist < (bulletSeekSize + ast.getSize() / bulletSeekFactor) * (bulletSeekSize + ast.getSize() / bulletSeekFactor)) {
                    dist22 += AstBulletFactor;
                }
            }
            if (dist22 >= minDist2) continue;
            minDist2 = dist22;
            nearest = ast;
        }
        Ufo ufo = info.getUfo();
        if (ufo != null && (dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize() - ufoPrioFactor) < minDist2) {
            nearest = ufo;
        }
        return nearest;
    }

    private static MovingGameObject findNearestBullet(SpaceShip ship, FrameInfo info) {
        Bullet nearest = null;
        int minDist2 = maxTargetDistence * maxTargetDistence;
        for (Bullet bull : info.getBullets()) {
            int dist2;
            Point delta = ship.getDelta(bull);
            Point delta2 = ship.getDelta(bull, 1);
            if (delta.x * delta.x + delta.y * delta.y <= delta2.x * delta2.x + delta2.y * delta2.y || (dist2 = ship.getSquaredDistance(bull)) >= minDist2) continue;
            minDist2 = dist2;
            nearest = bull;
        }
        return nearest;
    }

    private static MovingGameObject findNearestBullet(Asteroid asti, FrameInfo info) {
        Bullet nearest = null;
        int minDist2 = maxTargetDistence * maxTargetDistence;
        for (Bullet bull : info.getBullets()) {
            int dist2;
            Point delta = asti.getDelta(bull);
            Point delta2 = asti.getDelta(bull, 1);
            if (delta.x * delta.x + delta.y * delta.y <= delta2.x * delta2.x + delta2.y * delta2.y || (dist2 = asti.getSquaredDistance(bull)) >= minDist2) continue;
            minDist2 = dist2;
            nearest = bull;
        }
        return nearest;
    }

    private static MovingGameObject findRealNearestTarget(SpaceShip ship, FrameInfo info) {
        int dist2;
        MovingGameObject nearest = null;
        int minDist2 = maxTargetDistence * maxTargetDistence;
        for (Asteroid ast : info.getAsteroids()) {
            int dist22 = (int)Math.pow(Math.sqrt(ship.getSquaredDistance(ast)) - Math.sqrt(ast.getSquaredSize()), 2.0);
            if (dist22 >= minDist2) continue;
            minDist2 = dist22;
            nearest = ast;
        }
        Ufo ufo = info.getUfo();
        if (ufo != null && (dist2 = (int)Math.pow(Math.sqrt(ship.getSquaredDistance(ufo)) - Math.sqrt(ufo.getSquaredSize()), 2.0)) < minDist2) {
            nearest = ufo;
        }
        return nearest;
    }

    private static boolean needHyperSpace(SpaceShip ship, FrameInfo info) {
        for (Asteroid ast : info.getAsteroids()) {
            if (!ship.isOverlappingWith(ast.getBounds(1))) continue;
            return true;
        }
        for (Bullet bull : info.getBullets()) {
            if (!ship.isOverlappingWith(bull.getBounds(1))) continue;
            return true;
        }
        Ufo ufo = info.getUfo();
        return ufo != null && ship.isOverlappingWith(ufo.getBounds(1));
    }
}

