#ifndef PlayerH
#define PlayerH

#include "game.h"
#include "interfaceplayer.h"

class Player : public InterfacePlayer
{
  public:
   /* ctor */
  Player(void)
     : fire(0),
      state(DEFAULT),
      fire_state(OFF)
      {};

   virtual void MakeTurn(
      GameStatus&       gamestate,
      const GameStatus& lastGamestate,
      KeysPacket&       turn,
      const int         ping);

  private:

   enum state_e
   {
      DEFAULT,
      FIRE_AT_LARGE_ASTRO
   };

   enum fire_state_e
   {
      OFF,
      FIRED,
      FIRED_IN_LAST_CYCLE
   };

   int               fire;
   enum state_e      state;
   enum fire_state_e fire_state;

   void AimAngle(
      GameObject&  obj,
      const double initialAngle,
      const double alpha_ship) const;

};

#endif
