public class Keys 
{
	// Bit Taste 
	//	0 Hyperspace 
	//	1 Feuer 
	//	2 Schub 
	//	3 Rechts 
	//	4 Links 
	int k = 0;
	
	boolean canShoot = true;
	
	public void reset()
	{
		canShoot = ((k & 2) == 0);
		k = 0;
	}
	
	public void jump()
	{
		k |= 1;
	}
	
	public boolean shoot()
	{
		k |= (canShoot ? 2 : 0);
		return canShoot;
	}
	
	public void accelerate()
	{
		k |= 4;
	}
	
	public void right()
	{
		k |= 8;
	}
	
	public void left()
	{
		k |= 16;
	}
	
	public byte getVal()
	{
		return (byte) k;
	}
	
	public boolean isJump()
	{
		return (k & 1) > 0;
	}

	public boolean isRight()
	{
		return (k & 8) > 0;
	}

	public boolean isLeft()
	{
		return (k & 16) > 0;
	}
}
