// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// Utility code.
module utils;

bool inRange(T)(T x, T from, T to)
{
	return from<=x && x<=to;
}

T abs(T)(T x)
{
	return x<0?-x:x;
}

T min(T)(T x, T y)
{
	return x<y?x:y;
}

T max(T)(T x, T y)
{
	return x>y?x:y;
}

// cumulative text thing

struct CumulativeText
{
	string text;

	void add(string s)
	{
		if (text is null)
			return text = s;
		assert(text.length == s.length);
		foreach (i, ref t;text)
			if (t != s[i])
				t = '?';
	}

	string flush()
	{
		string result = text;
		text = null;
		return result;
	}
}

version (Windows)
{
	import std.c.windows.windows;
	extern(Windows) byte GetKeyState(DWORD);
	
	bool scrollLockStatus()
	{
		return (GetKeyState(VK_SCROLL)&1) != 0;
	}
}
else
	bool scrollLockStatus() { return false; }
