// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.util.Iterator;
import java.util.Locale;

/**
 *  A editor provider for a preference group which displays each peference property in a tab of its own.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision$
 */
class TabbedGroupEditor
        extends AbstractBasicGroupEditor
{
  /** The tabbed pane which holds the properties. */
  private JTabbedPane tabbedPane;

  /**
   *  Constructor.
   *  @param property group property
   *  @param l        locale
   */
  public TabbedGroupEditor(final EditablePreferenceGroup property, Locale l)
  {
    super(property.getNameTag(), l);

    tabbedPane = new JTabbedPane(JTabbedPane.NORTH, JTabbedPane.SCROLL_TAB_LAYOUT);
    for (Iterator iterator = property.propertyIterator();  iterator.hasNext();  ) {
      EditablePreferenceProperty epp = (EditablePreferenceProperty)iterator.next();
      EditorProvider provider = epp.getEditorProvider(l);
      addEditorProvider(provider);

      tabbedPane.addTab(provider.getTitleText(), new JScrollPane(provider.getEditor()));
      tabbedPane.setToolTipTextAt(tabbedPane.getTabCount()-1, provider.getToolTipText());
    }
    tabbedPane.addChangeListener(new ChangeListener() {
      public void stateChanged(ChangeEvent e)
      {
        property.setTabIndex(tabbedPane.getSelectedIndex());
      }
    });
    tabbedPane.setSelectedIndex(property.getTabIndex());
  }

  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return tabbedPane;
  }
}
