// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;

import javax.swing.*;
import java.awt.*;
import java.util.Iterator;
import java.util.Locale;

/**
 *  A editor provider for a preference group which displays all information in one panel.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
class PanelGroupEditor
        extends AbstractBasicGroupEditor
{
  /** The panel which holds the properties. */
  private JPanel panel;

  /**
   *  Constructor.
   *  @param property group property
   *  @param l        locale
   */
  public PanelGroupEditor(EditablePreferenceGroup property, Locale l)
  {
    super(property.getNameTag(), l);
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints constraints = new GridBagConstraints();
    constraints.ipadx = 4;
    constraints.ipady = 4;
    constraints.insets = new Insets(6, 4, 6, 4);

    panel = new JPanel(gbl);
    for (Iterator iterator = property.propertyIterator();  iterator.hasNext();  ) {
      EditablePreferenceProperty epp = (EditablePreferenceProperty)iterator.next();
      EditorProvider provider = epp.getEditorProvider(l);
      addEditorProvider(provider);

      final String name = provider.getLabelText();
      if (name != null) {
        JLabel label = new JLabel(I18n.format("valueNameFormat", name));

        constraints.gridwidth = GridBagConstraints.RELATIVE;
        constraints.fill      = GridBagConstraints.HORIZONTAL;
        constraints.anchor    = GridBagConstraints.NORTHWEST;
        gbl.setConstraints(label, constraints);
        panel.add(label);
        label.setToolTipText(provider.getToolTipText());

        constraints.anchor    = GridBagConstraints.NORTHEAST;
      }
      else {
        constraints.anchor    = GridBagConstraints.NORTHWEST;
      }
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill      = GridBagConstraints.BOTH;
      JComponent editor = provider.getEditor();
      gbl.setConstraints(editor, constraints);
      panel.add(editor);
      if (name == null) {
        String title = provider.getTitleText();
        if (title != null) {
          editor.setBorder(BorderFactory.createTitledBorder(title));
        }
      }

      editor.setToolTipText(provider.getToolTipText());
    }
  }

  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return panel;
  }

}
