// ============================================================================
// File:               $File$
//
// Project:
//
// Purpose:
//
// Author:             Rammi
//
// Copyright Notice:   (c) 1999-2006  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date: 2006-02-01 13:48:49 +0100 (Mi, 01 Feb 2006) $
//
// History:	       $Log$
//=============================================================================

package de.caff.util.debug;

import java.io.OutputStream;
import java.io.PrintStream;

/**
 *  A debug listener which copies all messages to a stream.
 *  It's useful for all categories of messages.
 *
 *  @see Debug
 *
 *  @author Rammi
 */
public class SimpleOutputtingDebugListener 
  implements CookedMessageDebugListener,
	     AnyMessageDebugListener
{
  private PrintStream _out;

  /**
   *  Construct a new listener for the given stream.
   *  @param  stream  output stream
   */
  public SimpleOutputtingDebugListener(OutputStream stream) {
    _out = new PrintStream(stream);
  }

  /**
   *  Write the message to the output stream.
   *  @param msg  message
   *  @param pos  postion
   */
  private void print(String msg, String pos) {
    _out.println(msg+"["+pos+"]");
  }

  /**
   *  Receive a raw trace debug message.
   *  @param msg  the message
   *  @param pos  postion
   */
  public void receiveTraceMessage(String msg, String pos) {
    print(msg, pos);
  }

  /**
   *  Receive a raw standard debug message.
   *  @param msg  die Meldung
   *  @param pos  postion
   */
  public void receiveStandardMessage(String msg, String pos) {
    print(msg, pos);
  }

  /**
   *  Receive a raw warning debug message.
   *  @param msg  the message
   *  @param pos  postion
   */
  public void receiveWarningMessage(String msg, String pos) {
    print(msg, pos);
  }

  /**
   *  Receive a raw error message.
   *  @param msg  the message
   *  @param pos  postion
   */
  public void receiveErrorMessage(String msg, String pos) {
    print(msg, pos);
  }

  /**
   *  Receive a raw logging debug message.
   *  @param msg  the message
   *  @param pos  postion
   */
  public void receiveLogMessage(String msg, String pos) {
    print(msg, pos);
  }

  /**
   *  Receive a raw fatal error message and return whether the program shall be
   *  exited.
   *  @param   msg  the message
   *  @param pos  postion
   *  @return  <code>1</code> -- exit the program
   */
  public int receiveFatalMessage(String msg, String pos) {
    print(msg, pos);
    return 1;
  }

  /**
   *  Receive a raw message about a failed assertion and return, whether an exception
   *  shall be thrown.
   *  @param   msg  the message
   *  @param pos  postion
   *  @return  <code>true</code> -- create exception
   */
  public boolean receiveFailedAssertionMessage(String msg, String pos) {
    print(msg, pos);
    return true;
  }

  
  /**
   *  Receive a cooked message. 
   *  @param   msgType message type (ignored)
   *  @param   msg     the message
   *  @param pos  postion
   */
  public void receiveCookedMessage(int msgType, String msg, String pos) {
    print(msg, pos);
  }

}
