// ============================================================================
// File:               $File$
//
// Project:
//
// Purpose:
//
// Author:             Rammi
//
// Copyright Notice:   (c) 1999-2006  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date: 2006-02-01 13:48:49 +0100 (Mi, 01 Feb 2006) $
//
// History:	       $Log$
//=============================================================================

package de.caff.util.debug;

/**
 *  A listener for failed assertions.
 *
 *  @see Debug
 *
 *  @author Rammi
 */
public interface AssertionMessageDebugListener
{
  /**
   *  Receive a raw message about a failed assertion and return, whether an exception
   *  shall be thrown.
   *  @param   msg  the message
   *  @param   pos  position
   *  @return  <code>true</code> -- create exception<br>
   *           <code>false</code> -- don't create exception
   */
  public boolean receiveFailedAssertionMessage(String msg, String pos);
}
