// ============================================================================
// File:               RJButton.java
//
// Project:            i18n 
//
// Purpose:            Button with localized label.
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2002  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================

package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;

import javax.swing.*;
import java.awt.*;
import java.util.Locale;

/**
 *  Button with localized label.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class RJButton
  extends    JButton 
  implements Localizable 
{
  /** Basic resource tag for button properties. */
  protected String   resTag;

  /**
   *  @param  tag       basic resource tag for the item
   */
  public RJButton(String tag)
  {
    setTag(tag);
  }

  /**
   *  @param  tag       basic resource tag for the item
   *  @param  icon      button icon
   */
  public RJButton(String tag, Icon icon)
  {
    setTag(tag);
    setIcon(icon);
  }

   protected void setTag(String baseTag)
  {
    resTag = baseTag;
    I18nHelper.setProperties(this, baseTag, getLocale());
  }

  /**
   * Notifies this component that it now has a parent component.
   * When this method is invoked, the chain of parent components is
   * set up with <code>KeyboardAction</code> event listeners.
   */
  public void addNotify()
  {
    super.addNotify();
    I18n.addLocalizationChangeListener(this);
  }

  /**
   * Overrides <code>JComponent.removeNotify</code> to check if
   * this button is currently set as the default button on the
   * <code>RootPane</code>, and if so, sets the <code>RootPane</code>'s
   * default button to <code>null</code> to ensure the
   * <code>RootPane</code> doesn't hold onto an invalid button reference.
   */
  public void removeNotify()
  {
    I18n.removeLocalizationChangeListener(this);
    super.removeNotify();
  }


  /**
   *  Change the locale of this Button
   *  @param  l   new Locale
   */
  public void setLocale(Locale l) {
    Locale oldLocale = getLocale();
    super.setLocale(l);
    if (oldLocale != null  &&  !oldLocale.equals(l)) {
      if (resTag != null) {
        setTag(resTag);
        invalidate();
      }
    }
  }


  /**
   *  Get the locale. Instead of throwing an <code>IllegalComponentStateException</code>
   *  when there's no locale we just return null.
   *  @return the Locale of this Label or null
   */
  public Locale getLocale() {
    try {
      return super.getLocale();
    } catch (IllegalComponentStateException x) {
      return null;
    }
  }


}




