/*
created: Jun 24, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.gui;

import java.awt.*;

import asteroids.*;



public class DebugPainter
{
  private final static Font NOTE_FONT = new Font("Arial", 0, 20);
  
  private static DebugPainter singleton = new DebugPainter();
  private GameWorld world;
  
  private Target greedyFocus;
  private Target collidingTarget;
  
  
  
  private DebugPainter()
  {
  }
  
  
  public static DebugPainter get()
  {
    return singleton;
  }
  
  
  public void setGameWorld(GameWorld world)
  {
    this.world = world;
  }


  public void setGreedyFocus(Target greedyFocus)
  {
    this.greedyFocus = greedyFocus;
  }


  public void setCollidingTarget(Target collidingTarget)
  {
    this.collidingTarget = collidingTarget;
  }
  
  
  private static void drawCircle(Graphics2D g, int x, int y, int r, Color color)
  {
    g.setColor(color);
    g.drawOval(x - r, y - r, r * 2, r * 2);
  }
  
  
  private static void drawVector(Graphics2D g, Target t)
  {
    if (t.getEstimationAccuracy() == 0) {
      return;
    }
    
    int x1 = t.getX();
    int y1 = t.getY();
    int x2 = x1 + Math.round(t.getSpeedX() * 60);
    int y2 = y1 + Math.round(t.getSpeedY() * 60);
    g.setColor(Color.GRAY);
    g.drawLine(x1, y1, x2, y2);
  }
  
  
  private static void drawCross(Graphics2D g, int x, int y, int r, Color color)
  {
    g.setColor(color);
    g.drawLine(x - r, y, x + r, y);
    g.drawLine(x, y - r, x, y + r);
  }


  public void paint(Graphics2D g)
  {
    synchronized (world)
    {
      //System.out.println("painting");
      
      //g.drawString("Hallo!", 528, 528);
      
      for (Target t : world.getTargetMonitor().getTargets()) {
        int x = t.getX();
        int y = t.getY();
        int r = t.getKind().getMaxRadius();
        
        if (t.getHitDirection() != null) {
          if (t.isFirePermission(world) && t.isDistanceOk(world)) {
            drawCircle(g, x, y, r, Color.GREEN);
          }
          else {
            drawCircle(g, x, y, r, Color.YELLOW);
          }
          //g.setFont(NOTE_FONT);
          //g.drawString("" + t.getHitDirection(), t.getX(), t.getY());
        }
        
        drawVector(g, t);
        
        if (t == greedyFocus) {
          drawCircle(g, x, y, r+4, Color.ORANGE);
        }
        
        if (t.getColor() != Target.DEFAULT_COLOR) {
            //t.getFireCount() > 0) {
          drawCross(g, x, y, 10, t.getColor());
        }
        
        if (t == collidingTarget) {
          drawCircle(g, x, y, 4, Color.RED);
        }
      }
      
      for (Bullet bullet : world.getBulletMonitor().getBullets()) {
        if (bullet.isTrackable()) {
          drawCross(g, bullet.getX(), bullet.getY(), 4, bullet.getColor());
        }
      }
    }
  }
}
