/*
created: Jun 18, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import de.heise.anniversary.contest.asteroids.*;



public enum TargetKind
{
  SMALL_ASTEROID(false, 5, 8),
  MEDIUM_ASTEROID(false, 18, 20), // TODO nicht 20?
  BIG_ASTEROID(false, 36, 40), // TODO nicht 40?
  SMALL_UFO(true, 6, 8 /* TODO optimieren */),
  BIG_UFO(true, 10, 12);
  
  private boolean ufo;
  private int minRadius;
  private int maxRadius;
  
  
  
  private TargetKind(boolean ufo, int minRadius, int maxRadius)
  {
    this.ufo = ufo;
    this.minRadius = minRadius;
    this.maxRadius = maxRadius;
  }
  
  
  public static TargetKind getAsteroidKind(Asteroid a)
  {
    switch (a.getSize()) {
      case SMALL :
        return TargetKind.SMALL_ASTEROID;
      case MIDDLE :
        return TargetKind.MEDIUM_ASTEROID;
      case BIG :
        return TargetKind.BIG_ASTEROID;
      default :
        throw new AssertionError("Unkown kind: " + a.getSize());
    }
  }
  
  
  public static TargetKind getUfoKind(Saucer s)
  {
    return s.getSize() == Saucer.Size.SMALL ?
           TargetKind.SMALL_UFO :
           TargetKind.BIG_UFO;
  }


  public boolean isUfo()
  {
    return ufo;
  }


  public int getMinRadius()
  {
    return minRadius;
  }
  
  
  public int getMaxRadius()
  {
    return maxRadius;
  }
}
