package asteroids;

/*
created: Jun 27, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
 */

import java.awt.Color;
import java.util.*;

import static asteroids.AsteroidsConstants.*;
import de.heise.anniversary.contest.asteroids.Shot;



public class BulletMonitor
{
  private LinkedList<Bullet> bullets = new LinkedList<Bullet>();
  //private int misses;
  
  
  
  public void addBullet(Bullet b)
  {
    //if (true) return;
    
    bullets.add(b);
    //assert bullets.size() <= SHOT_MAX;
  }
  
  
  public int getBulletCount()
  {
    return bullets.size();
  }
  
  
  public List<Bullet> getBullets()
  {
    return bullets;
  }
  
  
  public void sync(GameWorld world)
  {
    //if (true) return;
    
    List<Shot> shots = world.getGameStatus().getShots();
    List<Bullet> bl = new ArrayList<Bullet>();
    bl.addAll(bullets);
    
    for (Bullet b : bl) {
      b.sync(world);
      if (b.isExpired()) {
        Bullet first = bullets.poll();
        assert first != null;
        assert first == b;
      }
     
      
      else {
        if (b.isTrackable()) {
          Shot shot = null;
          for (Shot s : shots) {
            if (s.getX() == b.getX() &&
                s.getY() == b.getY()) {
              shot = s;
            }
          }
          if (shot == null) {
            /*
            Target t = b.getTarget();
                                    // besser testen ob wirklich zerstoert
            if (Tools.calcDistance(b.getX(), b.getY(), t.getX(), t.getY())
                               <= b.getTarget().getKind().getMinRadius()) {
              
            }
            */
            b.registerRemove();
            bullets.remove(b);
          }
        }
      }
      
    }
  }
}
