package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;

//import org.apache.log4j.Logger;

/**
 * Initializes the position (0, 0).
 */

/*
 *    --------- (1023,895) * Faktor
 *    |       |
 *    |       |
 *    ---------
 * (0,128) * Faktor
 */
public class Position {
	
//	public static final Logger logger = Logger.getLogger(Position.class);

	public static final int FAKTOR = 8; //faktor um den intern genauer skaliert wird
	public static final int screenSizeX = 1024*FAKTOR; 
	public static final int screenSizeY = 768*FAKTOR;
	public static final int offsetY = 128*FAKTOR;
	public static final int NOSIZEDEFINED = Integer.MIN_VALUE;
	
	static enum TYPE
	{
		ASTEROID,
		SHIP,
		SHOT,
		SAUCER,
		NICHTS
	}
	static enum AsteroidType {
		TYPE_1, TYPE_2, TYPE_3, TYPE_4, NICHTS
	}

	
	private int x=Integer.MIN_VALUE;
	private int y=Integer.MIN_VALUE;
	//aktuelle zeit der position
	private int time=Integer.MIN_VALUE; //current time
	//aktuelle orts-unsicherheit der position (zwischen 0..1)
	
	
	private int timeMin=Integer.MIN_VALUE; //min allowed time including this value
	private int timeMax=Integer.MIN_VALUE; //max allowed time including this value

	
	
	
	
	protected AsteroidType asteroidType = AsteroidType.NICHTS;
	protected TYPE type = TYPE.NICHTS;
	
	protected int size_inner = NOSIZEDEFINED;
	protected int size_outer = NOSIZEDEFINED;
	
	private String drawString = null;
	private Color drawColor = null;
	
	private boolean markiert = false;
	
	
	
	
	
	
	
	
	public Position estimatePosition(Vector v,int aktTick) {
		return estimatePosition(v, aktTick, true);
	}
	
	public Position estimatePosition(Vector v,int destTime,boolean checkmodulo) {

		if (v==null){
//			logger.debug("speed null, cannot estimate position!"+destTime+"   pos:"+this);
			return null;
		}
		
		if (destTime==time)	{
			return new Position(this);
		}
		
		int dt = destTime-time;
		int dx = v.getX();
		int dy = v.getY();

		//copy old position
		Position schaetzung = new Position(
				x + dx*dt,
				y + dy*dt,
				destTime,
				timeMin,
				timeMax,
				type,
				size_inner,
				size_outer,
				markiert
		);
		
		//kopiere den rest
		
		schaetzung.asteroidType = asteroidType;
		schaetzung.drawString = drawString;
		schaetzung.drawColor = drawColor;
		
		if (checkmodulo) schaetzung.setCorrectModulo();
		
		return schaetzung;
	}
	
	//mit zeitprfung
	public boolean isAliveAt(int t)
	{
		return (timeMin<=t) &&(t<=timeMax);
	}
	
	public boolean willBeAliveAndCetrainAfter(Vector bew, int time)
	{
		if (time>timeMax) return false;
		
		time = (int)Math.max(time, timeMin);

		if (bew==null || !bew.isValidCertaintyAt(time)) return false;
		
		Position p = estimatePosition(bew,time); //includes uncertain check
		
		return p==null?false:(p.isAliveAt(time));
		
	}	
	public int getMinTimeIsValid(Vector motion)
	{
		if (motion == null) return Integer.MAX_VALUE;
		return (int)Math.min(timeMin, motion.getTimeOfMinCertainty());
	}
	
	public int getMaxTimeIsValid(Vector motion)
	{
		if (motion == null) return Integer.MIN_VALUE;
		return (int)Math.min(timeMax, motion.getTimeOfMinCertainty());
	}
	
	public TYPE getType() {
		return type;
	}
	public AsteroidType getAsteroidType() {
		return asteroidType;
	}
	
	
	public void markiere(boolean b) {
		markiert = b;
	}
	public boolean getMarkierung() {
		return markiert;
	}

	public void setCorrectModulo(){
		x = getX(true);
		y = getY(true);
	}

	static boolean overflow(Position a, Position b, boolean xDirection) {
		if(xDirection)
			if (Math.abs(a.getX() - b.getX()) > screenSizeX/2)
				return true;
		else {
			if (Math.abs(a.getY() - b.getY()) > 300)
				return true;
		}
		return false;
	}
	
	
	/**
	 * @param x
	 * @param y
	 * @param zeitpunkt
	 */
	public Position(int x, int y, int zeitpunkt,
			int timeMin, int timeMax,
			TYPE type,int size_inner, int size_outer, boolean markiert
			) {
		super();
		this.x = x;
		this.y = y;
		this.time = zeitpunkt;
		this.timeMin = timeMin;
		this.timeMax = timeMax;
		
		this.size_inner = size_inner;
		this.size_outer = size_outer;
		
		this.type = type;
		this.markiert = markiert;
	}
	
	//copy constructor
	public Position(Position p) {
		
		if (p==null) return;

		x = p.x;
		y = p.y;
		time = p.time;
		timeMax = p.timeMax;
		timeMin = p.timeMin;
		
		
		size_inner = p.size_inner;
		size_outer = p.size_outer;
		
		type = p.type;
		asteroidType = p.asteroidType;
		
		drawString = p.drawString;
		drawColor = p.drawColor;
		
		markiert = p.markiert;
		
	}
	
	
	public void setTimeMin(int timeMin)
	{
		this.timeMin = timeMin;
	}
	public void setTimeMax(int timeMin)
	{
		this.timeMax = timeMin;
	}
	/**
	 * Returns the x-coordinate.
	 *
	 * @return x-coordinate
	 */
	final public int getX() {
		return x;
	}
	/**
	 * Returns the y-coordinate.
	 *
	 * @return y-coordinate
	 */
	final public int getY() {
		return y;
	}
	
	/**
	 * 
	 * @param checkModulo	if true tests, if the coordinate is within the field, if not corrects it 
	 * @return
	 */
	final public int getX(boolean checkModulo)
	{
		if (!checkModulo) return x;
		
		int xx = x % screenSizeX;
		return xx<0 ? xx+screenSizeX : xx;
	}
	
	final public int getY(boolean checkModulo)
	{
		if (!checkModulo) return y;

		int yy = ((y-offsetY) % screenSizeY);
		return (yy<0) ? yy+screenSizeY+ offsetY : yy + offsetY;
	}

	
	public int getZeitpunkt() {
		return time;
	}
	
	//Formel: PositionCertainty = Position.pCertainty + dCertainty*(time+dCertaintyStart)
	//	if time>=dCertaintyStart && time <maxCertTime
	// -> PositionCertainty = Math.max(Position.pCertainty,Position.pCertainty + dCertainty*(time+dCertaintyStart))


//	/**
//	 * Sets the x-coordinate.
//	 *
//	 * @param x
//	 * 			the x-coordinate
//	 */
//	final public void setX(int x) {
//		this.x = x;
//	}



	final public int getYforDrawing()
	{
		return (screenSizeY-(y-offsetY))/FAKTOR;
	}
	final public int getXforDrawing()
	{
		return x/FAKTOR;
	}
	
//	/**
//	 * Sets the y-coordinate
//	 *
//	 * @param y
//	 * 			the y-coordinate
//	 */
//	final public void setY(int y) {
//		this.y = y;
//	}
	
//	/*
//	 * Sets coordinates
//	 * 
//	 * @param x 
//	 * 		the x-coordinate
//	 * @param y
//	 * 		the y-coordinate
//	 */
//	final public void setXYT(int x, int y, int time) {
//		this.x = x;
//		this.y = y;
//		this.time = time;
//	}
//	
//	/** Substract vector <code>a</code> from <code>b</code>.
//	 *
//	 * @param a
//	 * 			a vector
//	 * @param b
//	 * 			a vector
//	 * @return the vector pointing from <code>b</code> to <code>a</code>
//	 */
//	public static Position substract(Position a, Position b) {
//		
//		if (a.time!=b.time || a.)
//		
//		return new Position(a.x - b.x,
//							a.y - b.y, 
//							a.getZeitpunkt()-b.getZeitpunkt(),
//							);
//	}
	public static float length(Position a) {
		return (float)Math.sqrt(a.getX()*a.getX() + a.getY() * a.getY());
	}
	public float length() {
		return (float)Math.sqrt(this.getX()*this.getX() + this.getY() * this.getY());
	}
	
	public float lengthSqared() {
		return ((float)x*x+y*y);
	}

	public boolean isSamePosition(Position a) {
		if (a==null) return false;
		return (this.x == a.x && this.y == a.y && this.time== a.time);
	}
	
	public static float distance(Position a, Position b) {
		return (float)Math.sqrt(distanceSquared(a,b));
	}
	
	public static float distanceSquared(Position a, Position b) {
		if (a==null || b==null || a.time!=b.time)
		{
//			logger.debug("error - cannot determine distance"+a.time+b.time+a+b);
			return Float.NaN;
		}
		 

		int distX = Math.abs(a.getX(true)-b.getX(true));
		if (distX > screenSizeX/2) distX-= screenSizeX;
			
		int distY = Math.abs(a.getY(true)-b.getY(true));
		if (distY > screenSizeY/2) distY-= screenSizeY;

		return (distX * distX + distY * distY);
	}

	public static int distanceSquaredIgnoreTime(Position a, Position b) {
		if (a==null || b==null)
		{
//			logger.debug("error - cannot determine distance"+a.time+b.time+a+b);
			return Integer.MAX_VALUE;
		}
		int distX = Math.abs(a.getX(true)-b.getX(true));
		if (distX > screenSizeX/2) distX-= screenSizeX;
			
		int distY = Math.abs(a.getY(true)-b.getY(true));
		if (distY > screenSizeY/2) distY-= screenSizeY;

		return (distX * distX + distY * distY);
	}
	
	

//
//	/**
//	 * Calculates the dot product for <code>a<code> and <code>b<code>.
//	 *
//	 * Results in <code>a.x * b.x + a.y * b.y</code>.
//	 *
//	 * @param a
//	 * 			a vector
//	 * @param b
//	 * 			a vector
//	 * @return the dot product for <code>a<code> and <code>b<code>
//	 */
//	public static float dotProduct(Position a, Position b) {
//		return a.x * b.x + a.y * b.y;
//	}
//	public static Position add(Position p, Vector v) {
//		return new Position(p.getX() + (int)(v.getX()), p.getY() + (int)(v.getY()), p.getZeitpunkt());
//	}
	
//	public void add(Vector v) {
//		this.x += v.getX();
//		this.y += v.getY();
//	}
//	public void add(int addX, int addY) {
//		x += addX;
//		y += addY;
//	}
//	public void abs() {
//		if (x < 0)
//			x = -x;
//		if (y < 0)
//			y = -y;
//	}
//	public Position add(Position p0, Position p1) {
//		return new Position(p0.getX() + p1.getX(), p0.getY() + p1.getY(), p0.getZeitpunkt());
//		//this.x += v.getX();
//		//this.y += v.getY();
//	}
	
	public String toString() {
		return "pos("+type+",a-Type="+asteroidType+",size="+size_inner+"/"+size_outer+",mark="+markiert+" "+toStringMyObject();
	}

	//position, zeit,type, ast-type
	public String toStringMyObject() {
		return type+",a-Type="+asteroidType+",pos(x="+x + ", y=" + y+",t="+time+")"+", tmin="+timeMin+", tmax="+timeMax+" ";
				
	}
	
//	/**
//	 * Calculates the 2D cross product for <code>a<code> and <code>b<code>.
//	 *
//	 * Results in <code>a.x * b.y - a.y * b.x</code>.
//	 *
//	 * @param a
//	 * 			a vector
//	 * @param b
//	 * 			a vector
//	 * @return the 2D cross product for <code>a<code> and <code>b<code>
//	 */
//	public static float crossProduct2D(Position a, Position b) {
//		return a.x * b.y - a.y * b.x;
//	}
	/*
	 * multiplizier mit FAKTOR
	 */
	public void toInternPosition() {
		x *= FAKTOR;
		y *= FAKTOR;
	}
	
	public void draw(Graphics2D g)
	{
		final int l=5;
		
		if (drawColor!=null) g.setColor(drawColor);
		
		g.drawLine(	getXforDrawing()-l, getYforDrawing()-l ,
					getXforDrawing()+l, getYforDrawing()+l);
		g.drawLine(	getXforDrawing()-l, getYforDrawing()+l ,
					getXforDrawing()+l, getYforDrawing()-l);
		
		if (drawString!=null)
			g.drawString(drawString,getXforDrawing()+l,getYforDrawing());
	}
	
	public void setDrawString(String drawString) {
		this.drawString = drawString;
	}
	public void setDrawColor(Color drawColor) {
		this.drawColor = drawColor;
	}
	public Color getDrawColor() {
		return drawColor;
	}
	
	
	public int getSize_inner() {
		return size_inner;
	}
	public int getSize_outer() {
		return size_outer;
	}
	public void setSize_inner(int size_inner) {
		this.size_inner = size_inner;
	}
	public void setSize_outer(int size_outer) {
		this.size_outer = size_outer;
	}

	public int getTimeMin() {
		return timeMin;
	}

	public int getTimeMax() {
		return timeMax;
	}
	
	
	
	
}